/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.compiler;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.tcp.compiler.TcpServiceValidator;
import io.ballerina.stdlib.tcp.compiler.Utils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.List;
import java.util.Optional;

public class TcpServiceValidatorTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String ORG_NAME = "ballerina";

    public void perform(SyntaxNodeAnalysisContext ctx) {
        List diagnostics = ctx.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)ctx.node();
        Optional serviceDeclarationSymbol = ctx.semanticModel().symbol((Node)serviceDeclarationNode);
        if (serviceDeclarationSymbol.isPresent()) {
            List listenerTypes = ((ServiceDeclarationSymbol)serviceDeclarationSymbol.get()).listenerTypes();
            for (TypeSymbol listenerType : listenerTypes) {
                if (!this.isListenerBelongsToTcpModule(listenerType)) continue;
                TcpServiceValidator tcpServiceValidator = new TcpServiceValidator(ctx);
                tcpServiceValidator.validate();
                return;
            }
        }
    }

    private boolean isTcpModule(ModuleSymbol moduleSymbol) {
        return Utils.equals((String)moduleSymbol.getName().get(), "tcp") && Utils.equals(moduleSymbol.id().orgName(), ORG_NAME);
    }

    private boolean isListenerBelongsToTcpModule(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> this.isTcpModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isTcpModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }
}

