/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.tcp.compiler;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.tcp.compiler.CompilationErrors;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public final class Utils {
    private Utils() {
    }

    public static boolean equals(String actual, String expected) {
        return actual.compareTo(expected) == 0;
    }

    public static boolean hasRemoteKeyword(FunctionDefinitionNode functionDefinitionNode) {
        return functionDefinitionNode.qualifierList().stream().filter(q -> q.kind() == SyntaxKind.REMOTE_KEYWORD).toArray().length == 1;
    }

    public static boolean hasRemoteKeyword(MethodSymbol methodSymbol) {
        return methodSymbol.qualifiers().stream().filter(qualifier -> qualifier == Qualifier.REMOTE).count() == 1L;
    }

    public static void reportDiagnostics(SyntaxNodeAnalysisContext ctx, CompilationErrors error, Location location, Object ... args) {
        String errorMessage = error.getError();
        String diagnosticCode = error.getErrorCode();
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode, errorMessage, DiagnosticSeverity.ERROR);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
        ctx.reportDiagnostic(diagnostic);
    }
}

