/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.regexp;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.TupleType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BRegexpValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.values.NonBmpStringValue;
import io.ballerina.runtime.internal.values.RegExpValue;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class RegexUtil {
    static final BTupleType SPAN_AS_TUPLE_TYPE = new BTupleType(List.of(PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_INT, PredefinedTypes.TYPE_STRING));
    static final BArrayType GROUPS_AS_SPAN_ARRAY_TYPE = new BArrayType((Type)SPAN_AS_TUPLE_TYPE);
    static final BArrayType GROUPS_ARRAY_TYPE = new BArrayType((Type)GROUPS_AS_SPAN_ARRAY_TYPE);

    private RegexUtil() {
    }

    static Matcher getMatcher(BRegexpValue regexpVal, BString inputStr) {
        try {
            return RegexUtil.getMatcher(regexpVal, inputStr.getValue());
        }
        catch (PatternSyntaxException e) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.REG_EXP_PARSING_ERROR, (ErrorCodes)ErrorCodes.REGEXP_INVALID_PATTERN, (Object[])new Object[]{e.getMessage()});
        }
    }

    static int[] getSurrogatePositions(BString str) {
        if (str instanceof NonBmpStringValue) {
            NonBmpStringValue nonBmpStringValue = (NonBmpStringValue)str;
            return nonBmpStringValue.getSurrogates();
        }
        return new int[0];
    }

    static int getSurrogateAdjustedStartIndex(int startIndex, int[] surrogates) {
        int newStartIndex = startIndex;
        for (int surrogate : surrogates) {
            if (startIndex != 0 && surrogate < startIndex) {
                ++newStartIndex;
                continue;
            }
            if (surrogate > startIndex) break;
        }
        return newStartIndex;
    }

    static Matcher getMatcher(BRegexpValue regexpVal, String inputStr) {
        RegExpValue translatedRegExpVal = RegExpFactory.translateRegExpConstructs((RegExpValue)((RegExpValue)regexpVal));
        String patternStr = StringUtils.getStringValue((Object)translatedRegExpVal);
        Pattern pattern = Pattern.compile(patternStr, 256);
        return pattern.matcher(inputStr);
    }

    static BArray getGroupZeroAsSpan(BString str, Matcher matcher, int[] surrogates) {
        BArray resultTuple = ValueCreator.createTupleValue((TupleType)SPAN_AS_TUPLE_TYPE);
        int[] adjustedPositions = RegexUtil.getAdjustedPositions(str, matcher, surrogates);
        resultTuple.add(0L, (long)adjustedPositions[0]);
        resultTuple.add(1L, (long)adjustedPositions[1]);
        resultTuple.add(2L, StringUtils.fromString((String)matcher.group()));
        return resultTuple;
    }

    static int[] getAdjustedPositions(BString str, Matcher matcher, int[] surrogates) {
        BString subString = StringUtils.fromString((String)matcher.group());
        return RegexUtil.getAdjustedPositions(str, matcher.start(), subString, surrogates);
    }

    static int[] getAdjustedPositions(BString str, int startIndex, BString subString, int[] surrogates) {
        int newStartIndex = startIndex;
        int prevSurrogate = 0;
        for (int surrogate : surrogates) {
            long offset = str.indexOf(subString, prevSurrogate);
            prevSurrogate = surrogate;
            if (offset != (long)surrogate && surrogate < startIndex) {
                --newStartIndex;
                continue;
            }
            if (surrogate > startIndex) break;
        }
        int newEndIndex = newStartIndex + subString.length();
        return new int[]{newStartIndex, newEndIndex};
    }

    static BArray getMatcherGroupsAsSpanArr(BString str, Matcher matcher, int[] surrogates) {
        BArray group = ValueCreator.createArrayValue((ArrayType)GROUPS_AS_SPAN_ARRAY_TYPE);
        BArray span = RegexUtil.getGroupZeroAsSpan(str, matcher, surrogates);
        group.append((Object)span);
        if (matcher.groupCount() == 0) {
            return group;
        }
        for (int i = 1; i <= matcher.groupCount(); ++i) {
            int matcherStart = matcher.start(i);
            if (matcherStart == -1) continue;
            BArray resultTuple = ValueCreator.createTupleValue((TupleType)SPAN_AS_TUPLE_TYPE);
            BString subString = StringUtils.fromString((String)matcher.group(i));
            int[] adjustedPositions = RegexUtil.getAdjustedPositions(str, matcherStart, subString, surrogates);
            resultTuple.add(0L, (long)adjustedPositions[0]);
            resultTuple.add(1L, (long)adjustedPositions[1]);
            resultTuple.add(2L, subString);
            group.append((Object)resultTuple);
        }
        return group;
    }

    public static BString substring(BString value, long startIndex, long endIndex) {
        return value.substring((int)startIndex, (int)endIndex);
    }

    public static long length(BString value) {
        return value.length();
    }

    static void checkIndexWithinRange(BString str, long startIndex) {
        if (startIndex != (long)((int)startIndex)) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.REGEXP_OPERATION_ERROR, (ErrorCodes)ErrorCodes.INDEX_NUMBER_TOO_LARGE, (Object[])new Object[]{startIndex});
        }
        if (startIndex < 0L) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.INDEX_OUT_OF_RANGE_ERROR, (ErrorCodes)ErrorCodes.NEGATIVE_REGEXP_FIND_INDEX, (Object[])new Object[0]);
        }
        int strLength = str.length();
        if (strLength != 0 && (long)strLength <= startIndex) {
            throw ErrorHelper.getRuntimeException((BString)ErrorReasons.INDEX_OUT_OF_RANGE_ERROR, (ErrorCodes)ErrorCodes.INVALID_REGEXP_FIND_INDEX, (Object[])new Object[]{startIndex, strLength});
        }
    }
}

