/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.xml;

import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.values.XmlPi;
import io.ballerina.runtime.internal.values.XmlSequence;
import org.ballerinalang.langlib.xml.IsComment;
import org.ballerinalang.langlib.xml.IsProcessingInstruction;

public final class GetContent {
    private GetContent() {
    }

    public static BString getContent(Object xmlVal) {
        BXml value = (BXml)xmlVal;
        if (IsProcessingInstruction.isProcessingInstruction(value)) {
            return GetContent.getPIContent(value);
        }
        if (IsComment.isComment(value)) {
            return GetContent.getCommentContent(value);
        }
        throw ErrorHelper.getRuntimeException((ErrorCodes)ErrorCodes.XML_FUNC_TYPE_ERROR, (Object[])new Object[]{"getContent", "processing instruction|comment"});
    }

    private static BString getCommentContent(BXml value) {
        if (value.getNodeType() == XmlNodeType.COMMENT) {
            return StringUtils.fromString((String)value.getTextValue());
        }
        return GetContent.getCommentContent((BXml)((XmlSequence)value).getItem(0));
    }

    private static BString getPIContent(BXml value) {
        if (value.getNodeType() == XmlNodeType.PI) {
            return StringUtils.fromString((String)((XmlPi)value).getData());
        }
        return GetContent.getPIContent((BXml)((XmlSequence)value).getItem(0));
    }
}

