/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.email.compiler;

import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public class EmailServiceValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private FunctionDefinitionNode onMessageFunctionNode;
    private FunctionDefinitionNode onCloseFunctionNode;
    private FunctionDefinitionNode onErrorFunctionNode;
    private String modulePrefix;
    private SyntaxNodeAnalysisContext ctx;
    public static final String CODE_101 = "EMAIL_101";
    public static final String CODE_102 = "EMAIL_102";
    public static final String CODE_103 = "EMAIL_103";
    public static final String CODE_104 = "EMAIL_104";
    public static final String CODE_105 = "EMAIL_105";
    public static final String CODE_106 = "EMAIL_106";
    public static final String CODE_107 = "EMAIL_107";
    public static final String SERVICE_MUST_CONTAIN_ON_MESSAGE_FUNCTION = "Service must contain `onMessage` function.";
    public static final String NO_PARAMETER_PROVIDED_FOR_0_FUNCTION_EXPECTS_1_AS_A_PARAMETER = "No parameter provided for `{0}`, function expects `{1}` as a parameter.";
    public static final String REMOTE_KEYWORD_EXPECTED_IN_0_FUNCTION_SIGNATURE = "`remote` keyword expected in `{0}` function signature.";
    public static final String RESOURCE_KEYWORD_NOT_EXPECTED_IN_0_FUNCTION_SIGNATURE = "`resource` keyword not expected in `{0}` function signature.";
    public static final String INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2 = "Invalid parameter `{0}` provided for `{1}`, function expects `{2}`.";
    public static final String INVALID_RETURN_TYPE_0_FUNCTION_1_RETURN_TYPE_SHOULD_BE_A_SUBTYPE_OF_2 = "Invalid return type `{0}` provided for function `{1}`, return type should be a subtype of `{2}`";
    public static final String FUNCTION_0_NOT_ACCEPTED_BY_THE_SERVICE = "Function `{0}` not accepted by the service";
    public static final String NILL = "()";

    public void perform(SyntaxNodeAnalysisContext ctx) {
        List diagnostics = ctx.semanticModel().diagnostics();
        for (Diagnostic diagnostic : diagnostics) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return;
        }
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)ctx.node();
        Optional serviceDeclarationSymbol = ctx.semanticModel().symbol((Node)serviceDeclarationNode);
        String modulePrefix = "email";
        ModulePartNode modulePartNode = (ModulePartNode)ctx.syntaxTree().rootNode();
        for (ImportDeclarationNode importDeclaration : modulePartNode.imports()) {
            if (((IdentifierToken)importDeclaration.moduleName().get(0)).toString().split(" ")[0].compareTo("email") != 0) continue;
            if (!importDeclaration.prefix().isPresent()) break;
            modulePrefix = ((ImportPrefixNode)importDeclaration.prefix().get()).children().get(1).toString();
            break;
        }
        if (serviceDeclarationSymbol.isPresent()) {
            List listenerTypes = ((ServiceDeclarationSymbol)serviceDeclarationSymbol.get()).listenerTypes();
            for (TypeSymbol listenerType : listenerTypes) {
                if (!this.isListenerBelongsToEmailModule(listenerType)) continue;
                this.ctx = ctx;
                this.modulePrefix = modulePrefix;
                this.validate();
            }
        }
    }

    private boolean isListenerBelongsToEmailModule(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> this.isEmailModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isEmailModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }

    private boolean isEmailModule(ModuleSymbol moduleSymbol) {
        return EmailServiceValidator.equals((String)moduleSymbol.getName().get(), "email") && EmailServiceValidator.equals(moduleSymbol.id().orgName(), "ballerina");
    }

    public static boolean equals(String actual, String expected) {
        return actual.compareTo(expected) == 0;
    }

    public void validate() {
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)this.ctx.node();
        serviceDeclarationNode.members().stream().filter(this::isResourceOrFunction).forEach(node -> {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            String functionName = functionDefinitionNode.functionName().toString();
            this.checkOnResourceFunctionExistence(functionDefinitionNode, functionName);
            Boolean isRemoteFunction = this.isRemoteFunction(functionDefinitionNode);
            Boolean notOnMessage = functionName.compareTo("onMessage") != 0;
            Boolean notOnError = functionName.compareTo("onError") != 0;
            Boolean notOnClose = functionName.compareTo("onClose") != 0;
            if (isRemoteFunction.booleanValue() && notOnMessage.booleanValue() && notOnError.booleanValue() && notOnClose.booleanValue()) {
                this.reportInvalidFunction(functionDefinitionNode);
            } else {
                this.onMessageFunctionNode = functionName.compareTo("onMessage") == 0 ? functionDefinitionNode : this.onMessageFunctionNode;
                this.onCloseFunctionNode = functionName.compareTo("onClose") == 0 ? functionDefinitionNode : this.onCloseFunctionNode;
                this.onErrorFunctionNode = functionName.compareTo("onError") == 0 ? functionDefinitionNode : this.onErrorFunctionNode;
            }
        });
        this.checkOnMessageFunctionExistence();
        this.validateFunctionSignature(this.onMessageFunctionNode, "onMessage");
        this.validateFunctionSignature(this.onCloseFunctionNode, "onClose");
        this.validateFunctionSignature(this.onErrorFunctionNode, "onError");
    }

    private void checkOnResourceFunctionExistence(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        boolean hasResourceKeyword;
        boolean bl = hasResourceKeyword = functionDefinitionNode.qualifierList().stream().filter(qualifier -> qualifier.kind() == SyntaxKind.RESOURCE_KEYWORD).toArray().length == 1;
        if (hasResourceKeyword) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_105, RESOURCE_KEYWORD_NOT_EXPECTED_IN_0_FUNCTION_SIGNATURE, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.functionKeyword().location(), (Object[])new Object[]{functionName}));
        }
    }

    private boolean isResourceOrFunction(Node node) {
        boolean isResource = node.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION;
        boolean isFunction = node.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION;
        return isResource || isFunction;
    }

    private boolean isRemoteFunction(FunctionDefinitionNode functionDefinitionNode) {
        return functionDefinitionNode.qualifierList().stream().filter(qualifier -> qualifier.kind() == SyntaxKind.REMOTE_KEYWORD).toArray().length == 1;
    }

    private void reportInvalidFunction(FunctionDefinitionNode functionDefinitionNode) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_103, FUNCTION_0_NOT_ACCEPTED_BY_THE_SERVICE, DiagnosticSeverity.ERROR);
        this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.location(), (Object[])new Object[]{functionDefinitionNode.functionName().toString()}));
    }

    private void validateFunctionSignature(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        if (functionDefinitionNode != null) {
            this.checkRemoteKeywords(functionDefinitionNode, functionName);
            SeparatedNodeList parameterNodes = functionDefinitionNode.functionSignature().parameters();
            if (this.hasNoParameters((SeparatedNodeList<ParameterNode>)parameterNodes, functionDefinitionNode, functionName)) {
                return;
            }
            this.validateParameter(functionDefinitionNode, (SeparatedNodeList<ParameterNode>)parameterNodes, functionName);
            this.validateFunctionReturnTypeDesc(functionDefinitionNode, functionName);
        }
    }

    private void checkOnMessageFunctionExistence() {
        if (this.onMessageFunctionNode == null) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_102, SERVICE_MUST_CONTAIN_ON_MESSAGE_FUNCTION, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)this.ctx.node().location(), (Object[])new Object[0]));
        }
    }

    private void checkRemoteKeywords(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        if (!this.isRemoteFunction(functionDefinitionNode)) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_101, REMOTE_KEYWORD_EXPECTED_IN_0_FUNCTION_SIGNATURE, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.functionKeyword().location(), (Object[])new Object[]{functionName}));
        }
    }

    private boolean hasNoParameters(SeparatedNodeList<ParameterNode> parameterNodes, FunctionDefinitionNode functionDefinitionNode, String functionName) {
        if (parameterNodes.isEmpty()) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_106, NO_PARAMETER_PROVIDED_FOR_0_FUNCTION_EXPECTS_1_AS_A_PARAMETER, DiagnosticSeverity.ERROR);
            String expectedParameter = functionName.equals("onMessage") ? this.modulePrefix + "Message" : (functionName.equals("onError") ? this.modulePrefix + "Error" : this.modulePrefix + "onClose");
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)functionDefinitionNode.functionSignature().location(), (Object[])new Object[]{functionName, expectedParameter}));
            return true;
        }
        return false;
    }

    private void validateParameter(FunctionDefinitionNode functionDefinitionNode, SeparatedNodeList<ParameterNode> parameterNodes, String functionName) {
        for (ParameterNode parameterNode : parameterNodes) {
            DiagnosticInfo diagnosticInfo;
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            Node parameterTypeName = requiredParameterNode.typeName();
            if (functionName.equals("onMessage") && !this.validateOnMessageParams(functionDefinitionNode)) {
                diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, DiagnosticSeverity.ERROR);
                this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName, this.modulePrefix + "Message"}));
                continue;
            }
            if (functionName.equals("onError") && !parameterTypeName.toString().contains("Error")) {
                diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, DiagnosticSeverity.ERROR);
                this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName, this.modulePrefix + "Error"}));
                continue;
            }
            if (!functionName.equals("onClose") || parameterTypeName.toString().contains("Error")) continue;
            diagnosticInfo = new DiagnosticInfo(CODE_104, INVALID_PARAMETER_0_PROVIDED_FOR_1_FUNCTION_EXPECTS_2, DiagnosticSeverity.ERROR);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)requiredParameterNode.location(), (Object[])new Object[]{requiredParameterNode, functionName, this.modulePrefix + "Error"}));
        }
    }

    private boolean validateOnMessageParams(FunctionDefinitionNode functionDefinitionNode) {
        FunctionTypeSymbol functionTypeSymbol = ((MethodSymbol)this.ctx.semanticModel().symbol((Node)functionDefinitionNode).get()).typeDescriptor();
        if (functionTypeSymbol.params().isPresent()) {
            List inputParams = (List)functionTypeSymbol.params().get();
            if (inputParams.size() != 1) {
                return false;
            }
            boolean isModuleValid = false;
            boolean isRecordValid = false;
            if (((ParameterSymbol)inputParams.get(0)).typeDescriptor().getModule().isPresent() && ((ModuleSymbol)((ParameterSymbol)inputParams.get(0)).typeDescriptor().getModule().get()).getName().isPresent()) {
                isModuleValid = "email".equals(((ModuleSymbol)((ParameterSymbol)inputParams.get(0)).typeDescriptor().getModule().get()).getName().get());
            }
            if (((ParameterSymbol)inputParams.get(0)).typeDescriptor().getName().isPresent()) {
                isRecordValid = "Message".equals(((ParameterSymbol)inputParams.get(0)).typeDescriptor().getName().get());
            }
            return isModuleValid && isRecordValid;
        }
        return false;
    }

    private void validateFunctionReturnTypeDesc(FunctionDefinitionNode functionDefinitionNode, String functionName) {
        Optional returnTypeDescriptorNode = functionDefinitionNode.functionSignature().returnTypeDesc();
        if (returnTypeDescriptorNode.isEmpty()) {
            return;
        }
        Node returnTypeDescriptor = ((ReturnTypeDescriptorNode)returnTypeDescriptorNode.get()).type();
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(CODE_107, INVALID_RETURN_TYPE_0_FUNCTION_1_RETURN_TYPE_SHOULD_BE_A_SUBTYPE_OF_2, DiagnosticSeverity.ERROR);
        this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)returnTypeDescriptor.location(), (Object[])new Object[]{returnTypeDescriptor.toString(), functionName, NILL}));
    }
}

