/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.os.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.os.nativeimpl.Errors;
import io.ballerina.stdlib.os.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.os.utils.OSUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class Exec {
    static final String VALUE = "value";
    static final String ARGUMENTS = "arguments";

    private Exec() {
    }

    public static Object exec(BMap<BString, Object> command, BMap<BString, Object> env) {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(command.getStringValue(StringUtils.fromString((String)VALUE)).getValue());
        String[] arguments = command.getArrayValue(StringUtils.fromString((String)ARGUMENTS)).getStringArray();
        Collections.addAll(commandList, arguments);
        ProcessBuilder pb = new ProcessBuilder(commandList);
        if (env != null) {
            Map<String, String> pbEnv = pb.environment();
            env.entrySet().forEach(entry -> pbEnv.put(((BString)entry.getKey()).getValue(), entry.getValue().toString()));
        }
        try {
            return OSUtils.getProcessObject(pb.start());
        }
        catch (IOException e) {
            return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)String.valueOf((Object)Errors.ProcessExecError), (BString)StringUtils.fromString((String)("Failed to retrieve the process object: " + e.getMessage())), null, null);
        }
    }
}

