/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.os.utils;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.os.nativeimpl.ModuleUtils;
import java.io.IOException;
import java.util.Map;

public final class OSUtils {
    private OSUtils() {
    }

    public static BObject getProcessObject(Process process) throws IOException {
        BObject obj = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"Process", (Object[])new Object[0]);
        obj.addNativeData("ProcessField", (Object)process);
        return obj;
    }

    public static Process processFromObject(BObject objVal) {
        return (Process)objVal.getNativeData("ProcessField");
    }

    public static BString getSystemProperty(BString key) {
        String value = System.getProperty(key.toString());
        if (value == null) {
            return StringUtils.fromString((String)PredefinedTypes.TYPE_STRING.getZeroValue().toString());
        }
        return StringUtils.fromString((String)value);
    }

    public static BMap<BString, Object> getEnvVariablesMap(Environment env) {
        Object envVarMap = env.getStrandLocal("io.ballerina.stdlib.os.environment.variables");
        if (envVarMap != null) {
            return (BMap)envVarMap;
        }
        MapType mapType = TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING);
        BMap envMap = ValueCreator.createMapValue((MapType)mapType);
        Map<String, String> jEnvMap = System.getenv();
        for (Map.Entry<String, String> entry : jEnvMap.entrySet()) {
            envMap.put((Object)StringUtils.fromString((String)entry.getKey()), (Object)StringUtils.fromString((String)entry.getValue()));
        }
        env.setStrandLocal("io.ballerina.stdlib.os.environment.variables", (Object)envMap);
        return envMap;
    }
}

