/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.validators.interfaces;

import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.constraint.Constants;
import io.ballerina.stdlib.constraint.ConstraintErrorInfo;
import io.ballerina.stdlib.constraint.InternalValidationException;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface DigitsValidator {
    default public void validate(Map.Entry<BString, Object> constraint, Object fieldValue, boolean isMemberValue, List<ConstraintErrorInfo> failedConstraints, String path) {
        Object constraintValue = constraint.getValue();
        String message = null;
        if (constraintValue instanceof BMap) {
            message = ((BMap)constraintValue).getStringValue(Constants.MESSAGE).getValue();
            constraintValue = ((BMap)constraintValue).get((Object)Constants.VALUE);
        }
        switch (constraint.getKey().getValue()) {
            case "maxDigits": {
                if (this.validateMaxDigits(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "maxDigits", isMemberValue));
                break;
            }
            case "maxIntegerDigits": {
                if (this.validateMaxIntegerDigits(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "maxIntegerDigits", isMemberValue));
                break;
            }
            case "maxFractionDigits": {
                if (this.validateMaxFractionDigits(fieldValue, constraintValue)) break;
                failedConstraints.add(new ConstraintErrorInfo(path, message, "maxFractionDigits", isMemberValue));
                break;
            }
        }
    }

    default public void checkDigitsConstraintValue(Map.Entry<BString, Object> constraint, String path) {
        Object constraintValue = constraint.getValue() instanceof BMap ? ((BMap)constraint.getValue()).get((Object)Constants.VALUE) : constraint.getValue();
        switch (constraint.getKey().getValue()) {
            case "maxDigits": 
            case "maxIntegerDigits": 
            case "maxFractionDigits": {
                long constraintLongValue = (Long)constraintValue;
                String constraintField = constraint.getKey().getValue();
                if (constraintLongValue > 0L) break;
                throw new InternalValidationException("invalid value found for " + path + ":" + constraintField + " constraint. Digits constraints should be positive");
            }
        }
    }

    default public DigitParts getDigitPartsFromDouble(double value) {
        String valueString = Double.toString(value);
        if (valueString.matches("^(-?[0-9]+)\\.([0-9]+)[Ee]([+-]?[0-9]+)$")) {
            return DigitsValidator.getDigitPartsFromScientificNotation(value, valueString);
        }
        return DigitsValidator.getDigitPartsFromString(value, valueString);
    }

    private static DigitParts getDigitPartsFromString(double value, String valueString) {
        int intDigits;
        String[] parts = valueString.split("\\.");
        int n = intDigits = value < 0.0 ? parts[0].length() - 1 : parts[0].length();
        if (parts.length == 1) {
            return new DigitParts(intDigits, 0);
        }
        return new DigitParts(intDigits, parts[1].length());
    }

    private static DigitParts getDigitPartsFromScientificNotation(double value, String valueString) {
        Pattern pattern = Pattern.compile("^(-?[0-9]+)\\.([0-9]+)[Ee]([+-]?[0-9]+)$");
        Matcher matcher = pattern.matcher(valueString);
        int intDigits = 0;
        int fractionDigits = 0;
        if (matcher.matches()) {
            String groupA = matcher.group(1);
            String groupB = matcher.group(2);
            String groupC = matcher.group(3);
            int countA = value < 0.0 ? groupA.length() - 1 : groupA.length();
            int countB = groupB.equals("0") ? 0 : groupB.length();
            int intC = Integer.parseInt(groupC);
            if (intC > 0) {
                intDigits = countA + Math.min(countB, intC);
                fractionDigits = countB - Math.min(countB, intC);
            } else {
                intDigits = Math.max(1, countA + intC);
                fractionDigits = countB - intC;
            }
        }
        return new DigitParts(intDigits, fractionDigits);
    }

    public boolean validateMaxDigits(Object var1, Object var2);

    public boolean validateMaxIntegerDigits(Object var1, Object var2);

    public boolean validateMaxFractionDigits(Object var1, Object var2);

    public record DigitParts(int integerDigits, int fractionDigits) {
    }
}

