/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.codeaction.providers;

import io.ballerina.c2c.tooling.toml.CommonUtil;
import io.ballerina.c2c.tooling.toml.TomlSyntaxTreeUtil;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CloudToml;
import io.ballerina.projects.Project;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.KeyValueNode;
import io.ballerina.toml.syntax.tree.StringLiteralNode;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.TableArrayNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddConfigsToK8sCodeAction
implements RangeBasedCodeActionProvider {
    public static final String CLOUD_CONFIG_ENVS = "cloud.config.envs";
    public static final String KEY_REF = "key_ref";

    public List<SyntaxKind> getSyntaxKinds() {
        return Collections.singletonList(SyntaxKind.MODULE_VAR_DECL);
    }

    public String getName() {
        return "Add Configs To K8s CodeAction";
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode matchedNode = positionDetails.matchedCodeActionNode();
        if (!this.isConfigurableVariable(matchedNode)) {
            return Collections.emptyList();
        }
        Path k8sPath = context.workspace().projectRoot(context.filePath()).resolve("Cloud.toml");
        Project project = (Project)context.workspace().project(context.filePath()).orElseThrow();
        if (!project.buildOptions().cloud().equals("k8s")) {
            return Collections.emptyList();
        }
        Optional cloudToml = project.currentPackage().cloudToml();
        if (cloudToml.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree tomlSyntaxTree = ((CloudToml)cloudToml.get()).tomlDocument().syntaxTree();
        DocumentNode documentNode = (DocumentNode)tomlSyntaxTree.rootNode();
        ArrayList<CodeAction> codeActionList = new ArrayList<CodeAction>();
        ModuleVariableDeclarationNode variableNode = (ModuleVariableDeclarationNode)matchedNode;
        BindingPatternNode bindingPatternNode = variableNode.typedBindingPattern().bindingPattern();
        if (bindingPatternNode.kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) {
            return codeActionList;
        }
        CaptureBindingPatternNode captureBindingPatternNode = (CaptureBindingPatternNode)bindingPatternNode;
        String variableName = captureBindingPatternNode.variableName().text();
        if (this.isEnvExistInK8sToml(documentNode, variableName)) {
            return codeActionList;
        }
        String importText = this.generateEnvArrayText(variableName);
        int endLine = documentNode.members().get(documentNode.members().size() - 1).lineRange().endLine().line();
        Position position = new Position(endLine + 1, 0);
        List<TextEdit> edits = Collections.singletonList(new TextEdit(new Range(position, position), importText));
        CodeAction action = CommonUtil.createQuickFixCodeAction("Add as env to Cloud.toml", edits, k8sPath.toUri().toString());
        codeActionList.add(action);
        return codeActionList;
    }

    private boolean isConfigurableVariable(NonTerminalNode matchedNode) {
        if (matchedNode.kind() != SyntaxKind.MODULE_VAR_DECL) {
            return false;
        }
        ModuleVariableDeclarationNode variableDeclarationNode = (ModuleVariableDeclarationNode)matchedNode;
        for (io.ballerina.compiler.syntax.tree.Token qualifier : variableDeclarationNode.qualifiers()) {
            if (qualifier.kind() != SyntaxKind.CONFIGURABLE_KEYWORD) continue;
            return true;
        }
        return false;
    }

    private boolean isEnvExistInK8sToml(DocumentNode documentNode, String variableName) {
        for (DocumentMemberDeclarationNode member : documentNode.members()) {
            TableArrayNode tableNode;
            String tableArrayName;
            if (member.kind() != io.ballerina.toml.syntax.tree.SyntaxKind.TABLE_ARRAY || !(tableArrayName = TomlSyntaxTreeUtil.toDottedString((tableNode = (TableArrayNode)member).identifier().value())).equals(CLOUD_CONFIG_ENVS) || !this.isEnvExistInTableArray(variableName, tableNode)) continue;
            return true;
        }
        return false;
    }

    private boolean isEnvExistInTableArray(String variableName, TableArrayNode tableNode) {
        for (KeyValueNode keyValueNode : tableNode.fields()) {
            StringLiteralNode stringNode;
            Optional<Token> content;
            ValueNode value;
            String key = TomlSyntaxTreeUtil.toDottedString(keyValueNode.identifier().value());
            if (!key.equals(KEY_REF) || (value = keyValueNode.value()).kind() != io.ballerina.toml.syntax.tree.SyntaxKind.STRING_LITERAL || !(content = (stringNode = (StringLiteralNode)value).content()).isPresent() || !content.get().text().equals(variableName)) continue;
            return true;
        }
        return false;
    }

    private String generateEnvArrayText(String configVariable) {
        return CommonUtil.LINE_SEPARATOR + "[[cloud.config.envs]]" + CommonUtil.LINE_SEPARATOR + "key_ref=\"" + configVariable + "\"" + CommonUtil.LINE_SEPARATOR + "config_name=\"" + configVariable + "\"" + CommonUtil.LINE_SEPARATOR;
    }
}

