/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.codeaction.providers;

import io.ballerina.c2c.tooling.toml.CommonUtil;
import io.ballerina.c2c.tooling.toml.TomlSyntaxTreeUtil;
import io.ballerina.c2c.util.ListenerInfo;
import io.ballerina.c2c.util.ProjectServiceInfo;
import io.ballerina.c2c.util.ServiceInfo;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.CloudToml;
import io.ballerina.projects.Project;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.SyntaxTree;
import io.ballerina.toml.syntax.tree.TableNode;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddResourceToK8sCodeAction
implements RangeBasedCodeActionProvider {
    public List<SyntaxKind> getSyntaxKinds() {
        return Collections.singletonList(SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
    }

    public String getName() {
        return "Add Resource To K8s Code Action";
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        NonTerminalNode matchedNode = positionDetails.matchedCodeActionNode();
        if (matchedNode.kind() != SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
            return Collections.emptyList();
        }
        Path k8sPath = context.workspace().projectRoot(context.filePath()).resolve("Cloud.toml");
        Project project = (Project)context.workspace().project(context.filePath()).orElseThrow();
        if (!project.buildOptions().cloud().equals("k8s")) {
            return Collections.emptyList();
        }
        Optional cloudToml = project.currentPackage().cloudToml();
        if (cloudToml.isEmpty()) {
            return Collections.emptyList();
        }
        SyntaxTree tomlSyntaxTree = ((CloudToml)cloudToml.get()).tomlDocument().syntaxTree();
        DocumentNode documentNode = (DocumentNode)tomlSyntaxTree.rootNode();
        List<ProbeType> probs = this.getAvailableProbes(documentNode);
        ArrayList<CodeAction> codeActionList = new ArrayList<CodeAction>();
        for (ProbeType probe : probs) {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)matchedNode;
            String resourcePath = this.toAbsoluteServicePath(functionDefinitionNode.relativeResourcePath());
            ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)functionDefinitionNode.parent();
            String servicePath = this.toAbsoluteServicePath(serviceDeclarationNode.absoluteResourcePath());
            List<Integer> ports = this.getPortOfService(project, servicePath);
            if (ports.isEmpty()) continue;
            String importText = this.generateProbeText(probe, ports.get(0), servicePath, resourcePath);
            int endLine = documentNode.members().get(documentNode.members().size() - 1).lineRange().endLine().line();
            Position position = new Position(endLine + 1, 0);
            List<TextEdit> edits = Collections.singletonList(new TextEdit(new Range(position, position), importText));
            CodeAction action = CommonUtil.createQuickFixCodeAction("Add as " + probe.tableName + " probe", edits, k8sPath.toUri().toString());
            codeActionList.add(action);
        }
        return codeActionList;
    }

    private List<ProbeType> getAvailableProbes(DocumentNode documentNode) {
        ArrayList<ProbeType> probs = new ArrayList<ProbeType>();
        probs.add(ProbeType.LIVENESS);
        probs.add(ProbeType.READINESS);
        for (DocumentMemberDeclarationNode member : documentNode.members()) {
            if (member.kind() != io.ballerina.toml.syntax.tree.SyntaxKind.TABLE) continue;
            TableNode tableNode = (TableNode)member;
            String tableName = TomlSyntaxTreeUtil.toDottedString(tableNode.identifier().value());
            if (tableName.equals("cloud.deployment.probes.liveness")) {
                probs.remove((Object)ProbeType.LIVENESS);
            }
            if (!tableName.equals("cloud.deployment.probes.readiness")) continue;
            probs.remove((Object)ProbeType.READINESS);
        }
        return probs;
    }

    private List<Integer> getPortOfService(Project project, String servicePath) {
        ArrayList<Integer> ports = new ArrayList<Integer>();
        ProjectServiceInfo projectServiceInfo = new ProjectServiceInfo(project);
        List<ServiceInfo> serviceList = projectServiceInfo.getServiceList();
        for (ServiceInfo serviceInfo : serviceList) {
            if (!serviceInfo.getServicePath().equals(servicePath)) continue;
            List<ListenerInfo> listeners = serviceInfo.getListeners();
            for (ListenerInfo listenerInfo : listeners) {
                ports.add(listenerInfo.getPort());
            }
        }
        return ports;
    }

    private String toAbsoluteServicePath(NodeList<Node> servicePathNodes) {
        StringBuilder absoluteServicePath = new StringBuilder();
        for (Node serviceNode : servicePathNodes) {
            absoluteServicePath.append(serviceNode.toString());
        }
        return absoluteServicePath.toString().trim();
    }

    private String generateProbeText(ProbeType probeType, int port, String servicePath, String resourcePath) {
        resourcePath = ((String)resourcePath).equals(".") ? "" : "/" + (String)resourcePath;
        if (servicePath.equals("/")) {
            return CommonUtil.LINE_SEPARATOR + "[cloud.deployment.probes." + probeType.tableName + "]" + CommonUtil.LINE_SEPARATOR + "port = " + port + CommonUtil.LINE_SEPARATOR + "path = \"" + (String)resourcePath + "\"" + CommonUtil.LINE_SEPARATOR;
        }
        return CommonUtil.LINE_SEPARATOR + "[cloud.deployment.probes." + probeType.tableName + "]" + CommonUtil.LINE_SEPARATOR + "port = " + port + CommonUtil.LINE_SEPARATOR + "path = \"" + servicePath + (String)resourcePath + "\"" + CommonUtil.LINE_SEPARATOR;
    }

    static enum ProbeType {
        LIVENESS("liveness"),
        READINESS("readiness");

        final String tableName;

        private ProbeType(String tableName) {
            this.tableName = tableName;
        }
    }
}

