/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tooling.command;

import io.ballerina.c2c.tooling.toml.CommonUtil;
import io.ballerina.projects.Project;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.validator.BoilerplateGenerator;
import io.ballerina.toml.validator.schema.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.ballerinalang.langserver.commons.ExecuteCommandContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CreateFile;
import org.eclipse.lsp4j.CreateFileOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ResourceOperation;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;

public class CreateCloudTomlExecutor
implements LSCommandExecutor {
    public static final String COMMAND = "ballerina.create.cloud.exec";

    public Object execute(ExecuteCommandContext context) {
        String content = this.generateContent();
        List arguments = context.getArguments();
        if (arguments.size() != 1) {
            return Collections.emptyList();
        }
        CommandArgument arg = (CommandArgument)arguments.get(0);
        if (!"uri".equals(arg.key())) {
            return Collections.emptyList();
        }
        String documentUri = (String)arg.valueAs(String.class);
        Optional<Path> filePath = CommonUtil.getPathFromURI(documentUri);
        if (filePath.isEmpty()) {
            return Collections.emptyList();
        }
        Optional project = context.workspace().project(filePath.get());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        Optional cloudToml = ((Project)project.get()).currentPackage().cloudToml();
        if (cloudToml.isPresent()) {
            return Collections.emptyList();
        }
        ArrayList<Either<TextDocumentEdit, ResourceOperation>> actionsToTake = new ArrayList<Either<TextDocumentEdit, ResourceOperation>>(2);
        String docURI = ((Project)project.get()).sourceRoot().resolve("Cloud.toml").toUri().toString();
        actionsToTake.add(Either.forRight((Object)new CreateFile(docURI, new CreateFileOptions(Boolean.valueOf(false), Boolean.valueOf(true)))));
        VersionedTextDocumentIdentifier identifier = new VersionedTextDocumentIdentifier(docURI, Integer.valueOf(0));
        TextEdit te = new TextEdit(new Range(new Position(0, 0), new Position(0, 0)), content);
        actionsToTake.add(Either.forLeft((Object)new TextDocumentEdit(identifier, Collections.singletonList(te))));
        ExtendedLanguageClient languageClient = context.getLanguageClient();
        return CreateCloudTomlExecutor.applyWorkspaceEdit(actionsToTake, (LanguageClient)languageClient);
    }

    private String generateContent() {
        StringBuilder content = new StringBuilder("# This file contains most used configurations supported by Ballerina Code to Cloud" + CommonUtil.LINE_SEPARATOR + "# All the fields are optional. If these fields are not specified, default value will be taken from the compiler." + CommonUtil.LINE_SEPARATOR + "# Full Code to Cloud specification can be accessed from https://github.com/ballerina-platform/ballerina-spec/blob/master/c2c/code-to-cloud-spec.md" + CommonUtil.LINE_SEPARATOR + "# Uncomment Any field below if you want to override the default value." + CommonUtil.LINE_SEPARATOR);
        BoilerplateGenerator generator = new BoilerplateGenerator(Schema.from(this.getValidationSchema()));
        Map<String, DocumentMemberDeclarationNode> nodes = generator.getNodes();
        nodes.remove("cloud.config.secrets");
        nodes.remove("cloud.config.files");
        for (DocumentMemberDeclarationNode node : nodes.values()) {
            if (node.kind() != SyntaxKind.KEY_VALUE) {
                content.append(CommonUtil.LINE_SEPARATOR);
            }
            String nodeContent = node.toSourceCode();
            nodeContent = nodeContent.replaceAll("\n", "\n#");
            content.append(nodeContent);
        }
        return content.toString();
    }

    public String getCommand() {
        return COMMAND;
    }

    public static Object applyWorkspaceEdit(List<Either<TextDocumentEdit, ResourceOperation>> documentChanges, LanguageClient client) {
        WorkspaceEdit workspaceEdit = new WorkspaceEdit(documentChanges);
        ApplyWorkspaceEditParams applyWorkspaceEditParams = new ApplyWorkspaceEditParams(workspaceEdit);
        if (client != null) {
            client.applyEdit(applyWorkspaceEditParams);
        }
        return applyWorkspaceEditParams;
    }

    private String getValidationSchema() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("c2c-schema-tooling.json");
            if (inputStream == null) {
                throw new MissingResourceException("Schema Not found", "c2c-schema-tooling.json", "");
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
            return writer.toString();
        }
        catch (IOException e) {
            throw new MissingResourceException("Schema Not found", "c2c-schema-tooling.json", "");
        }
    }
}

