/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser;

import io.ballerina.compiler.internal.parser.AbstractParserErrorHandler;
import io.ballerina.compiler.internal.parser.AbstractTokenReader;
import io.ballerina.compiler.internal.parser.ParserRuleContext;
import io.ballerina.compiler.internal.parser.Result;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayDeque;

public class XMLParserErrorHandler
extends AbstractParserErrorHandler {
    private static final ParserRuleContext[] XML_CONTENT = new ParserRuleContext[]{ParserRuleContext.XML_START_OR_EMPTY_TAG, ParserRuleContext.XML_TEXT, ParserRuleContext.XML_END_TAG, ParserRuleContext.XML_COMMENT_START, ParserRuleContext.XML_PI, ParserRuleContext.XML_CDATA_START};
    private static final ParserRuleContext[] XML_ATTRIBUTES = new ParserRuleContext[]{ParserRuleContext.XML_ATTRIBUTE, ParserRuleContext.XML_START_OR_EMPTY_TAG_END};
    private static final ParserRuleContext[] XML_START_OR_EMPTY_TAG_END = new ParserRuleContext[]{ParserRuleContext.GT_TOKEN, ParserRuleContext.SLASH};
    private static final ParserRuleContext[] XML_ATTRIBUTE_VALUE_ITEM = new ParserRuleContext[]{ParserRuleContext.XML_ATTRIBUTE_VALUE_TEXT, ParserRuleContext.XML_QUOTE_END};
    private static final ParserRuleContext[] XML_PI_TARGET_RHS = new ParserRuleContext[]{ParserRuleContext.XML_PI_END, ParserRuleContext.XML_PI_DATA};
    private static final ParserRuleContext[] XML_OPTIONAL_CDATA_CONTENT = new ParserRuleContext[]{ParserRuleContext.XML_CDATA_END, ParserRuleContext.XML_CDATA_CONTENT};

    public XMLParserErrorHandler(AbstractTokenReader tokenReader) {
        super(tokenReader);
    }

    @Override
    protected boolean hasAlternativePaths(ParserRuleContext currentCtx) {
        return switch (currentCtx) {
            case ParserRuleContext.XML_CONTENT, ParserRuleContext.XML_ATTRIBUTES, ParserRuleContext.XML_START_OR_EMPTY_TAG_END, ParserRuleContext.XML_ATTRIBUTE_VALUE_ITEM, ParserRuleContext.XML_PI_TARGET_RHS, ParserRuleContext.XML_OPTIONAL_CDATA_CONTENT -> true;
            default -> false;
        };
    }

    @Override
    protected Result seekMatch(ParserRuleContext currentCtx, int lookahead, int currentDepth, boolean isEntryPoint) {
        int matchingRulesCount = 0;
        while (currentDepth < 4) {
            boolean hasMatch = true;
            boolean skipRule = false;
            STToken nextToken = this.tokenReader.peek(lookahead);
            if (nextToken.kind == SyntaxKind.INTERPOLATION_START_TOKEN) {
                nextToken = this.tokenReader.peek(lookahead += 2);
            }
            switch (currentCtx) {
                case EOF: {
                    hasMatch = nextToken.kind == SyntaxKind.EOF_TOKEN;
                    break;
                }
                case LT_TOKEN: {
                    hasMatch = nextToken.kind == SyntaxKind.LT_TOKEN;
                    break;
                }
                case GT_TOKEN: {
                    hasMatch = nextToken.kind == SyntaxKind.GT_TOKEN;
                    break;
                }
                case XML_NAME: {
                    hasMatch = nextToken.kind == SyntaxKind.IDENTIFIER_TOKEN;
                    break;
                }
                case XML_TEXT: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_TEXT;
                    break;
                }
                case SLASH: {
                    hasMatch = nextToken.kind == SyntaxKind.SLASH_TOKEN;
                    break;
                }
                case ASSIGN_OP: {
                    hasMatch = nextToken.kind == SyntaxKind.EQUAL_TOKEN;
                    break;
                }
                case XML_COMMENT_START: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_COMMENT_START_TOKEN;
                    break;
                }
                case XML_COMMENT_CONTENT: 
                case XML_ATTRIBUTE_VALUE_TEXT: 
                case XML_PI_DATA: 
                case XML_CDATA_CONTENT: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_TEXT_CONTENT;
                    break;
                }
                case XML_COMMENT_END: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_COMMENT_END_TOKEN;
                    break;
                }
                case XML_PI_START: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_PI_START_TOKEN;
                    break;
                }
                case XML_PI_END: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_PI_END_TOKEN;
                    break;
                }
                case XML_QUOTE_START: 
                case XML_QUOTE_END: {
                    hasMatch = nextToken.kind == SyntaxKind.DOUBLE_QUOTE_TOKEN || nextToken.kind == SyntaxKind.SINGLE_QUOTE_TOKEN;
                    break;
                }
                case XML_CDATA_START: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_CDATA_START_TOKEN;
                    break;
                }
                case XML_CDATA_END: {
                    hasMatch = nextToken.kind == SyntaxKind.XML_CDATA_END_TOKEN;
                    break;
                }
                default: {
                    if (this.hasAlternativePaths(currentCtx)) {
                        return this.seekMatchInAlternativePaths(currentCtx, lookahead, currentDepth, matchingRulesCount, isEntryPoint);
                    }
                    skipRule = true;
                    hasMatch = true;
                }
            }
            if (!hasMatch) {
                return this.fixAndContinue(currentCtx, lookahead, currentDepth, matchingRulesCount, isEntryPoint);
            }
            currentCtx = this.getNextRule(currentCtx, lookahead + 1);
            if (skipRule) continue;
            ++currentDepth;
            ++matchingRulesCount;
            ++lookahead;
            isEntryPoint = false;
        }
        Result result = new Result(new ArrayDeque<AbstractParserErrorHandler.Solution>(), matchingRulesCount);
        result.solution = new AbstractParserErrorHandler.Solution(AbstractParserErrorHandler.Action.KEEP, currentCtx, this.getExpectedTokenKind(currentCtx), currentCtx.toString());
        return result;
    }

    private Result seekMatchInAlternativePaths(ParserRuleContext currentCtx, int lookahead, int currentDepth, int matchingRulesCount, boolean isEntryPoint) {
        ParserRuleContext[] alternativeRules = switch (currentCtx) {
            case ParserRuleContext.XML_CONTENT -> XML_CONTENT;
            case ParserRuleContext.XML_ATTRIBUTES -> XML_ATTRIBUTES;
            case ParserRuleContext.XML_START_OR_EMPTY_TAG_END -> XML_START_OR_EMPTY_TAG_END;
            case ParserRuleContext.XML_ATTRIBUTE_VALUE_ITEM -> XML_ATTRIBUTE_VALUE_ITEM;
            case ParserRuleContext.XML_PI_TARGET_RHS -> XML_PI_TARGET_RHS;
            case ParserRuleContext.XML_OPTIONAL_CDATA_CONTENT -> XML_OPTIONAL_CDATA_CONTENT;
            default -> throw new IllegalStateException("seekMatchInExprRelatedAlternativePaths found: " + String.valueOf((Object)currentCtx));
        };
        return this.seekInAlternativesPaths(lookahead, currentDepth, matchingRulesCount, alternativeRules, isEntryPoint);
    }

    @Override
    protected ParserRuleContext getNextRule(ParserRuleContext currentCtx, int nextLookahead) {
        switch (currentCtx) {
            case XML_ATTRIBUTES: 
            case XML_START_OR_EMPTY_TAG: 
            case XML_END_TAG: 
            case XML_PI: {
                this.startContext(currentCtx);
                break;
            }
        }
        switch (currentCtx) {
            case XML_START_OR_EMPTY_TAG: 
            case XML_END_TAG: {
                return ParserRuleContext.LT_TOKEN;
            }
            case LT_TOKEN: {
                ParserRuleContext parentCtx = this.getParentContext();
                return switch (parentCtx) {
                    case ParserRuleContext.XML_START_OR_EMPTY_TAG -> ParserRuleContext.XML_NAME;
                    case ParserRuleContext.XML_END_TAG -> ParserRuleContext.SLASH;
                    default -> throw new IllegalStateException(" < cannot exist in: " + String.valueOf((Object)parentCtx));
                };
            }
            case GT_TOKEN: 
            case XML_PI_END: {
                this.endContext();
                return ParserRuleContext.XML_CONTENT;
            }
            case XML_NAME: {
                ParserRuleContext parentCtx = this.getParentContext();
                return switch (parentCtx) {
                    case ParserRuleContext.XML_START_OR_EMPTY_TAG -> ParserRuleContext.XML_ATTRIBUTES;
                    case ParserRuleContext.XML_END_TAG -> ParserRuleContext.GT_TOKEN;
                    case ParserRuleContext.XML_ATTRIBUTES -> ParserRuleContext.ASSIGN_OP;
                    case ParserRuleContext.XML_PI -> ParserRuleContext.XML_PI_TARGET_RHS;
                    default -> throw new IllegalStateException("XML name cannot exist in: " + String.valueOf((Object)parentCtx));
                };
            }
            case SLASH: {
                ParserRuleContext parentCtx = this.getParentContext();
                return switch (parentCtx) {
                    case ParserRuleContext.XML_ATTRIBUTES -> {
                        this.endContext();
                        yield ParserRuleContext.GT_TOKEN;
                    }
                    case ParserRuleContext.XML_START_OR_EMPTY_TAG -> ParserRuleContext.GT_TOKEN;
                    case ParserRuleContext.XML_END_TAG -> ParserRuleContext.XML_NAME;
                    default -> throw new IllegalStateException("slash cannot exist in: " + String.valueOf((Object)parentCtx));
                };
            }
            case ASSIGN_OP: {
                return ParserRuleContext.XML_QUOTE_START;
            }
            case XML_ATTRIBUTE: {
                return ParserRuleContext.XML_NAME;
            }
            case XML_QUOTE_END: {
                return ParserRuleContext.XML_ATTRIBUTES;
            }
            case XML_COMMENT_START: {
                return ParserRuleContext.XML_COMMENT_CONTENT;
            }
            case XML_COMMENT_CONTENT: {
                return ParserRuleContext.XML_COMMENT_END;
            }
            case XML_TEXT: 
            case XML_COMMENT_END: {
                return ParserRuleContext.XML_CONTENT;
            }
            case XML_PI: {
                return ParserRuleContext.XML_PI_START;
            }
            case XML_PI_START: {
                return ParserRuleContext.XML_NAME;
            }
            case XML_PI_DATA: {
                return ParserRuleContext.XML_PI_END;
            }
            case XML_ATTRIBUTE_VALUE_TEXT: 
            case XML_QUOTE_START: {
                return ParserRuleContext.XML_ATTRIBUTE_VALUE_ITEM;
            }
            case XML_CDATA_START: {
                return ParserRuleContext.XML_OPTIONAL_CDATA_CONTENT;
            }
            case XML_CDATA_CONTENT: {
                return ParserRuleContext.XML_CDATA_END;
            }
            case XML_CDATA_END: {
                return ParserRuleContext.XML_CONTENT;
            }
        }
        throw new IllegalStateException("cannot find the next rule for: " + String.valueOf((Object)currentCtx));
    }

    @Override
    protected AbstractParserErrorHandler.Solution getInsertSolution(ParserRuleContext ctx) {
        SyntaxKind expectedTokenKind = this.getExpectedTokenKind(ctx);
        return new AbstractParserErrorHandler.Solution(AbstractParserErrorHandler.Action.INSERT, ctx, expectedTokenKind, ctx.toString());
    }

    @Override
    protected SyntaxKind getExpectedTokenKind(ParserRuleContext context) {
        return switch (context) {
            case ParserRuleContext.LT_TOKEN, ParserRuleContext.XML_START_OR_EMPTY_TAG, ParserRuleContext.XML_END_TAG -> SyntaxKind.LT_TOKEN;
            case ParserRuleContext.GT_TOKEN -> SyntaxKind.GT_TOKEN;
            case ParserRuleContext.SLASH -> SyntaxKind.SLASH_TOKEN;
            case ParserRuleContext.XML_KEYWORD -> SyntaxKind.XML_KEYWORD;
            case ParserRuleContext.XML_NAME -> SyntaxKind.IDENTIFIER_TOKEN;
            case ParserRuleContext.ASSIGN_OP -> SyntaxKind.EQUAL_TOKEN;
            case ParserRuleContext.XML_ATTRIBUTES, ParserRuleContext.XML_START_OR_EMPTY_TAG_END -> SyntaxKind.GT_TOKEN;
            case ParserRuleContext.XML_CONTENT, ParserRuleContext.XML_TEXT -> SyntaxKind.BACKTICK_TOKEN;
            case ParserRuleContext.XML_COMMENT_START -> SyntaxKind.XML_COMMENT_START_TOKEN;
            case ParserRuleContext.XML_COMMENT_CONTENT -> SyntaxKind.XML_TEXT_CONTENT;
            case ParserRuleContext.XML_COMMENT_END -> SyntaxKind.XML_COMMENT_END_TOKEN;
            case ParserRuleContext.XML_PI_START, ParserRuleContext.XML_PI -> SyntaxKind.XML_PI_START_TOKEN;
            case ParserRuleContext.XML_PI_END -> SyntaxKind.XML_PI_END_TOKEN;
            case ParserRuleContext.XML_PI_DATA -> SyntaxKind.XML_TEXT_CONTENT;
            case ParserRuleContext.XML_QUOTE_START, ParserRuleContext.XML_QUOTE_END -> SyntaxKind.DOUBLE_QUOTE_TOKEN;
            case ParserRuleContext.XML_CDATA_END -> SyntaxKind.XML_CDATA_END_TOKEN;
            default -> SyntaxKind.NONE;
        };
    }
}

