/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.AnnotationAttachPointNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STAnnotationAttachPointNode
extends STNode {
    public final STNode sourceKeyword;
    public final STNode identifiers;

    STAnnotationAttachPointNode(STNode sourceKeyword, STNode identifiers) {
        this(sourceKeyword, identifiers, Collections.emptyList());
    }

    STAnnotationAttachPointNode(STNode sourceKeyword, STNode identifiers, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ANNOTATION_ATTACH_POINT, diagnostics);
        this.sourceKeyword = sourceKeyword;
        this.identifiers = identifiers;
        this.addChildren(sourceKeyword, identifiers);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STAnnotationAttachPointNode(this.sourceKeyword, this.identifiers, diagnostics);
    }

    public STAnnotationAttachPointNode modify(STNode sourceKeyword, STNode identifiers) {
        if (this.checkForReferenceEquality(sourceKeyword, identifiers)) {
            return this;
        }
        return new STAnnotationAttachPointNode(sourceKeyword, identifiers, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new AnnotationAttachPointNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

