/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STAnnotationNode
extends STNode {
    public final STNode atToken;
    public final STNode annotReference;
    public final STNode annotValue;

    STAnnotationNode(STNode atToken, STNode annotReference, STNode annotValue) {
        this(atToken, annotReference, annotValue, Collections.emptyList());
    }

    STAnnotationNode(STNode atToken, STNode annotReference, STNode annotValue, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ANNOTATION, diagnostics);
        this.atToken = atToken;
        this.annotReference = annotReference;
        this.annotValue = annotValue;
        this.addChildren(atToken, annotReference, annotValue);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STAnnotationNode(this.atToken, this.annotReference, this.annotValue, diagnostics);
    }

    public STAnnotationNode modify(STNode atToken, STNode annotReference, STNode annotValue) {
        if (this.checkForReferenceEquality(atToken, annotReference, annotValue)) {
            return this;
        }
        return new STAnnotationNode(atToken, annotReference, annotValue, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new AnnotationNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

