/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STBlockStatementNode
extends STStatementNode {
    public final STNode openBraceToken;
    public final STNode statements;
    public final STNode closeBraceToken;

    STBlockStatementNode(STNode openBraceToken, STNode statements, STNode closeBraceToken) {
        this(openBraceToken, statements, closeBraceToken, Collections.emptyList());
    }

    STBlockStatementNode(STNode openBraceToken, STNode statements, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.BLOCK_STATEMENT, diagnostics);
        this.openBraceToken = openBraceToken;
        this.statements = statements;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(openBraceToken, statements, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STBlockStatementNode(this.openBraceToken, this.statements, this.closeBraceToken, diagnostics);
    }

    public STBlockStatementNode modify(STNode openBraceToken, STNode statements, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, statements, closeBraceToken)) {
            return this;
        }
        return new STBlockStatementNode(openBraceToken, statements, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new BlockStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

