/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STCheckExpressionNode
extends STExpressionNode {
    public final STNode checkKeyword;
    public final STNode expression;

    STCheckExpressionNode(SyntaxKind kind, STNode checkKeyword, STNode expression) {
        this(kind, checkKeyword, expression, Collections.emptyList());
    }

    STCheckExpressionNode(SyntaxKind kind, STNode checkKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(kind, diagnostics);
        this.checkKeyword = checkKeyword;
        this.expression = expression;
        this.addChildren(checkKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STCheckExpressionNode(this.kind, this.checkKeyword, this.expression, diagnostics);
    }

    public STCheckExpressionNode modify(SyntaxKind kind, STNode checkKeyword, STNode expression) {
        if (this.checkForReferenceEquality(checkKeyword, expression)) {
            return this;
        }
        return new STCheckExpressionNode(kind, checkKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new CheckExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

