/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.CollectClauseNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STCollectClauseNode
extends STClauseNode {
    public final STNode collectKeyword;
    public final STNode expression;

    STCollectClauseNode(STNode collectKeyword, STNode expression) {
        this(collectKeyword, expression, Collections.emptyList());
    }

    STCollectClauseNode(STNode collectKeyword, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.COLLECT_CLAUSE, diagnostics);
        this.collectKeyword = collectKeyword;
        this.expression = expression;
        this.addChildren(collectKeyword, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STCollectClauseNode(this.collectKeyword, this.expression, diagnostics);
    }

    public STCollectClauseNode modify(STNode collectKeyword, STNode expression) {
        if (this.checkForReferenceEquality(collectKeyword, expression)) {
            return this;
        }
        return new STCollectClauseNode(collectKeyword, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new CollectClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

