/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.DistinctTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDistinctTypeDescriptorNode
extends STTypeDescriptorNode {
    public final STNode distinctKeyword;
    public final STNode typeDescriptor;

    STDistinctTypeDescriptorNode(STNode distinctKeyword, STNode typeDescriptor) {
        this(distinctKeyword, typeDescriptor, Collections.emptyList());
    }

    STDistinctTypeDescriptorNode(STNode distinctKeyword, STNode typeDescriptor, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.DISTINCT_TYPE_DESC, diagnostics);
        this.distinctKeyword = distinctKeyword;
        this.typeDescriptor = typeDescriptor;
        this.addChildren(distinctKeyword, typeDescriptor);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDistinctTypeDescriptorNode(this.distinctKeyword, this.typeDescriptor, diagnostics);
    }

    public STDistinctTypeDescriptorNode modify(STNode distinctKeyword, STNode typeDescriptor) {
        if (this.checkForReferenceEquality(distinctKeyword, typeDescriptor)) {
            return this;
        }
        return new STDistinctTypeDescriptorNode(distinctKeyword, typeDescriptor, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new DistinctTypeDescriptorNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

