/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STEnumMemberNode
extends STNode {
    public final STNode metadata;
    public final STNode identifier;
    public final STNode equalToken;
    public final STNode constExprNode;

    STEnumMemberNode(STNode metadata, STNode identifier, STNode equalToken, STNode constExprNode) {
        this(metadata, identifier, equalToken, constExprNode, Collections.emptyList());
    }

    STEnumMemberNode(STNode metadata, STNode identifier, STNode equalToken, STNode constExprNode, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ENUM_MEMBER, diagnostics);
        this.metadata = metadata;
        this.identifier = identifier;
        this.equalToken = equalToken;
        this.constExprNode = constExprNode;
        this.addChildren(metadata, identifier, equalToken, constExprNode);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STEnumMemberNode(this.metadata, this.identifier, this.equalToken, this.constExprNode, diagnostics);
    }

    public STEnumMemberNode modify(STNode metadata, STNode identifier, STNode equalToken, STNode constExprNode) {
        if (this.checkForReferenceEquality(metadata, identifier, equalToken, constExprNode)) {
            return this;
        }
        return new STEnumMemberNode(metadata, identifier, equalToken, constExprNode, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new EnumMemberNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

