/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STClauseNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnClauseNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOnClauseNode
extends STClauseNode {
    public final STNode onKeyword;
    public final STNode lhsExpression;
    public final STNode equalsKeyword;
    public final STNode rhsExpression;

    STOnClauseNode(STNode onKeyword, STNode lhsExpression, STNode equalsKeyword, STNode rhsExpression) {
        this(onKeyword, lhsExpression, equalsKeyword, rhsExpression, Collections.emptyList());
    }

    STOnClauseNode(STNode onKeyword, STNode lhsExpression, STNode equalsKeyword, STNode rhsExpression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ON_CLAUSE, diagnostics);
        this.onKeyword = onKeyword;
        this.lhsExpression = lhsExpression;
        this.equalsKeyword = equalsKeyword;
        this.rhsExpression = rhsExpression;
        this.addChildren(onKeyword, lhsExpression, equalsKeyword, rhsExpression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOnClauseNode(this.onKeyword, this.lhsExpression, this.equalsKeyword, this.rhsExpression, diagnostics);
    }

    public STOnClauseNode modify(STNode onKeyword, STNode lhsExpression, STNode equalsKeyword, STNode rhsExpression) {
        if (this.checkForReferenceEquality(onKeyword, lhsExpression, equalsKeyword, rhsExpression)) {
            return this;
        }
        return new STOnClauseNode(onKeyword, lhsExpression, equalsKeyword, rhsExpression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OnClauseNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

