/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OrderKeyNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STOrderKeyNode
extends STNode {
    public final STNode expression;
    public final STNode orderDirection;

    STOrderKeyNode(STNode expression, STNode orderDirection) {
        this(expression, orderDirection, Collections.emptyList());
    }

    STOrderKeyNode(STNode expression, STNode orderDirection, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ORDER_KEY, diagnostics);
        this.expression = expression;
        this.orderDirection = orderDirection;
        this.addChildren(expression, orderDirection);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STOrderKeyNode(this.expression, this.orderDirection, diagnostics);
    }

    public STOrderKeyNode modify(STNode expression, STNode orderDirection) {
        if (this.checkForReferenceEquality(expression, orderDirection)) {
            return this;
        }
        return new STOrderKeyNode(expression, orderDirection, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new OrderKeyNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

