/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeCastExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STTypeCastExpressionNode
extends STExpressionNode {
    public final STNode ltToken;
    public final STNode typeCastParam;
    public final STNode gtToken;
    public final STNode expression;

    STTypeCastExpressionNode(STNode ltToken, STNode typeCastParam, STNode gtToken, STNode expression) {
        this(ltToken, typeCastParam, gtToken, expression, Collections.emptyList());
    }

    STTypeCastExpressionNode(STNode ltToken, STNode typeCastParam, STNode gtToken, STNode expression, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TYPE_CAST_EXPRESSION, diagnostics);
        this.ltToken = ltToken;
        this.typeCastParam = typeCastParam;
        this.gtToken = gtToken;
        this.expression = expression;
        this.addChildren(ltToken, typeCastParam, gtToken, expression);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTypeCastExpressionNode(this.ltToken, this.typeCastParam, this.gtToken, this.expression, diagnostics);
    }

    public STTypeCastExpressionNode modify(STNode ltToken, STNode typeCastParam, STNode gtToken, STNode expression) {
        if (this.checkForReferenceEquality(ltToken, typeCastParam, gtToken, expression)) {
            return this;
        }
        return new STTypeCastExpressionNode(ltToken, typeCastParam, gtToken, expression, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TypeCastExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

