/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLStepMethodCallExtendNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLStepMethodCallExtendNode
extends STNode {
    public final STNode dotToken;
    public final STNode methodName;
    public final STNode parenthesizedArgList;

    STXMLStepMethodCallExtendNode(STNode dotToken, STNode methodName, STNode parenthesizedArgList) {
        this(dotToken, methodName, parenthesizedArgList, Collections.emptyList());
    }

    STXMLStepMethodCallExtendNode(STNode dotToken, STNode methodName, STNode parenthesizedArgList, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_STEP_METHOD_CALL_EXTEND, diagnostics);
        this.dotToken = dotToken;
        this.methodName = methodName;
        this.parenthesizedArgList = parenthesizedArgList;
        this.addChildren(dotToken, methodName, parenthesizedArgList);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLStepMethodCallExtendNode(this.dotToken, this.methodName, this.parenthesizedArgList, diagnostics);
    }

    public STXMLStepMethodCallExtendNode modify(STNode dotToken, STNode methodName, STNode parenthesizedArgList) {
        if (this.checkForReferenceEquality(dotToken, methodName, parenthesizedArgList)) {
            return this;
        }
        return new STXMLStepMethodCallExtendNode(dotToken, methodName, parenthesizedArgList, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLStepMethodCallExtendNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

