/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import java.util.Objects;

public class AlternateReceiveNode
extends NonTerminalNode {
    public AlternateReceiveNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SeparatedNodeList<SimpleNameReferenceNode> workers() {
        return new SeparatedNodeList<SimpleNameReferenceNode>((NonTerminalNode)this.childInBucket(0));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"workers"};
    }

    public AlternateReceiveNode modify(SeparatedNodeList<SimpleNameReferenceNode> workers) {
        if (this.checkForReferenceEquality(workers.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createAlternateReceiveNode(workers);
    }

    public AlternateReceiveNodeModifier modify() {
        return new AlternateReceiveNodeModifier(this);
    }

    public static class AlternateReceiveNodeModifier {
        private final AlternateReceiveNode oldNode;
        private SeparatedNodeList<SimpleNameReferenceNode> workers;

        public AlternateReceiveNodeModifier(AlternateReceiveNode oldNode) {
            this.oldNode = oldNode;
            this.workers = oldNode.workers();
        }

        public AlternateReceiveNodeModifier withWorkers(SeparatedNodeList<SimpleNameReferenceNode> workers) {
            Objects.requireNonNull(workers, "workers must not be null");
            this.workers = workers;
            return this;
        }

        public AlternateReceiveNode apply() {
            return this.oldNode.modify(this.workers);
        }
    }
}

