/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ComputedNameFieldNode
extends MappingFieldNode {
    public ComputedNameFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode fieldNameExpr() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    public Token colonToken() {
        return (Token)this.childInBucket(3);
    }

    public ExpressionNode valueExpr() {
        return (ExpressionNode)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "fieldNameExpr", "closeBracket", "colonToken", "valueExpr"};
    }

    public ComputedNameFieldNode modify(Token openBracket, ExpressionNode fieldNameExpr, Token closeBracket, Token colonToken, ExpressionNode valueExpr) {
        if (this.checkForReferenceEquality(openBracket, fieldNameExpr, closeBracket, colonToken, valueExpr)) {
            return this;
        }
        return NodeFactory.createComputedNameFieldNode(openBracket, fieldNameExpr, closeBracket, colonToken, valueExpr);
    }

    public ComputedNameFieldNodeModifier modify() {
        return new ComputedNameFieldNodeModifier(this);
    }

    public static class ComputedNameFieldNodeModifier {
        private final ComputedNameFieldNode oldNode;
        private Token openBracket;
        private ExpressionNode fieldNameExpr;
        private Token closeBracket;
        private Token colonToken;
        private ExpressionNode valueExpr;

        public ComputedNameFieldNodeModifier(ComputedNameFieldNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.fieldNameExpr = oldNode.fieldNameExpr();
            this.closeBracket = oldNode.closeBracket();
            this.colonToken = oldNode.colonToken();
            this.valueExpr = oldNode.valueExpr();
        }

        public ComputedNameFieldNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ComputedNameFieldNodeModifier withFieldNameExpr(ExpressionNode fieldNameExpr) {
            Objects.requireNonNull(fieldNameExpr, "fieldNameExpr must not be null");
            this.fieldNameExpr = fieldNameExpr;
            return this;
        }

        public ComputedNameFieldNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ComputedNameFieldNodeModifier withColonToken(Token colonToken) {
            Objects.requireNonNull(colonToken, "colonToken must not be null");
            this.colonToken = colonToken;
            return this;
        }

        public ComputedNameFieldNodeModifier withValueExpr(ExpressionNode valueExpr) {
            Objects.requireNonNull(valueExpr, "valueExpr must not be null");
            this.valueExpr = valueExpr;
            return this;
        }

        public ComputedNameFieldNode apply() {
            return this.oldNode.modify(this.openBracket, this.fieldNameExpr, this.closeBracket, this.colonToken, this.valueExpr);
        }
    }
}

