/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ErrorConstructorExpressionNode
extends ExpressionNode {
    public ErrorConstructorExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token errorKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<TypeDescriptorNode> typeReference() {
        return this.optionalChildInBucket(1);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(2);
    }

    public SeparatedNodeList<FunctionArgumentNode> arguments() {
        return new SeparatedNodeList<FunctionArgumentNode>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"errorKeyword", "typeReference", "openParenToken", "arguments", "closeParenToken"};
    }

    public ErrorConstructorExpressionNode modify(Token errorKeyword, TypeDescriptorNode typeReference, Token openParenToken, SeparatedNodeList<FunctionArgumentNode> arguments, Token closeParenToken) {
        if (this.checkForReferenceEquality(errorKeyword, typeReference, openParenToken, arguments.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createErrorConstructorExpressionNode(errorKeyword, typeReference, openParenToken, arguments, closeParenToken);
    }

    public ErrorConstructorExpressionNodeModifier modify() {
        return new ErrorConstructorExpressionNodeModifier(this);
    }

    public static class ErrorConstructorExpressionNodeModifier {
        private final ErrorConstructorExpressionNode oldNode;
        private Token errorKeyword;
        private TypeDescriptorNode typeReference;
        private Token openParenToken;
        private SeparatedNodeList<FunctionArgumentNode> arguments;
        private Token closeParenToken;

        public ErrorConstructorExpressionNodeModifier(ErrorConstructorExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.errorKeyword = oldNode.errorKeyword();
            this.typeReference = oldNode.typeReference().orElse(null);
            this.openParenToken = oldNode.openParenToken();
            this.arguments = oldNode.arguments();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public ErrorConstructorExpressionNodeModifier withErrorKeyword(Token errorKeyword) {
            Objects.requireNonNull(errorKeyword, "errorKeyword must not be null");
            this.errorKeyword = errorKeyword;
            return this;
        }

        public ErrorConstructorExpressionNodeModifier withTypeReference(TypeDescriptorNode typeReference) {
            this.typeReference = typeReference;
            return this;
        }

        public ErrorConstructorExpressionNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public ErrorConstructorExpressionNodeModifier withArguments(SeparatedNodeList<FunctionArgumentNode> arguments) {
            Objects.requireNonNull(arguments, "arguments must not be null");
            this.arguments = arguments;
            return this;
        }

        public ErrorConstructorExpressionNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public ErrorConstructorExpressionNode apply() {
            return this.oldNode.modify(this.errorKeyword, this.typeReference, this.openParenToken, this.arguments, this.closeParenToken);
        }
    }
}

