/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class FunctionTypeDescriptorNode
extends TypeDescriptorNode {
    public FunctionTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<Token> qualifierList() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(0));
    }

    public Token functionKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Optional<FunctionSignatureNode> functionSignature() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"qualifierList", "functionKeyword", "functionSignature"};
    }

    public FunctionTypeDescriptorNode modify(NodeList<Token> qualifierList, Token functionKeyword, FunctionSignatureNode functionSignature) {
        if (this.checkForReferenceEquality(qualifierList.underlyingListNode(), functionKeyword, functionSignature)) {
            return this;
        }
        return NodeFactory.createFunctionTypeDescriptorNode(qualifierList, functionKeyword, functionSignature);
    }

    public FunctionTypeDescriptorNodeModifier modify() {
        return new FunctionTypeDescriptorNodeModifier(this);
    }

    public static class FunctionTypeDescriptorNodeModifier {
        private final FunctionTypeDescriptorNode oldNode;
        private NodeList<Token> qualifierList;
        private Token functionKeyword;
        private FunctionSignatureNode functionSignature;

        public FunctionTypeDescriptorNodeModifier(FunctionTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.qualifierList = oldNode.qualifierList();
            this.functionKeyword = oldNode.functionKeyword();
            this.functionSignature = oldNode.functionSignature().orElse(null);
        }

        public FunctionTypeDescriptorNodeModifier withQualifierList(NodeList<Token> qualifierList) {
            Objects.requireNonNull(qualifierList, "qualifierList must not be null");
            this.qualifierList = qualifierList;
            return this;
        }

        public FunctionTypeDescriptorNodeModifier withFunctionKeyword(Token functionKeyword) {
            Objects.requireNonNull(functionKeyword, "functionKeyword must not be null");
            this.functionKeyword = functionKeyword;
            return this;
        }

        public FunctionTypeDescriptorNodeModifier withFunctionSignature(FunctionSignatureNode functionSignature) {
            this.functionSignature = functionSignature;
            return this;
        }

        public FunctionTypeDescriptorNode apply() {
            return this.oldNode.modify(this.qualifierList, this.functionKeyword, this.functionSignature);
        }
    }
}

