/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class IndexedExpressionNode
extends TypeDescriptorNode {
    public IndexedExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode containerExpression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(1);
    }

    public SeparatedNodeList<ExpressionNode> keyExpression() {
        return new SeparatedNodeList<ExpressionNode>((NonTerminalNode)this.childInBucket(2));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"containerExpression", "openBracket", "keyExpression", "closeBracket"};
    }

    public IndexedExpressionNode modify(ExpressionNode containerExpression, Token openBracket, SeparatedNodeList<ExpressionNode> keyExpression, Token closeBracket) {
        if (this.checkForReferenceEquality(containerExpression, openBracket, keyExpression.underlyingListNode(), closeBracket)) {
            return this;
        }
        return NodeFactory.createIndexedExpressionNode(containerExpression, openBracket, keyExpression, closeBracket);
    }

    public IndexedExpressionNodeModifier modify() {
        return new IndexedExpressionNodeModifier(this);
    }

    public static class IndexedExpressionNodeModifier {
        private final IndexedExpressionNode oldNode;
        private ExpressionNode containerExpression;
        private Token openBracket;
        private SeparatedNodeList<ExpressionNode> keyExpression;
        private Token closeBracket;

        public IndexedExpressionNodeModifier(IndexedExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.containerExpression = oldNode.containerExpression();
            this.openBracket = oldNode.openBracket();
            this.keyExpression = oldNode.keyExpression();
            this.closeBracket = oldNode.closeBracket();
        }

        public IndexedExpressionNodeModifier withContainerExpression(ExpressionNode containerExpression) {
            Objects.requireNonNull(containerExpression, "containerExpression must not be null");
            this.containerExpression = containerExpression;
            return this;
        }

        public IndexedExpressionNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public IndexedExpressionNodeModifier withKeyExpression(SeparatedNodeList<ExpressionNode> keyExpression) {
            Objects.requireNonNull(keyExpression, "keyExpression must not be null");
            this.keyExpression = keyExpression;
            return this;
        }

        public IndexedExpressionNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public IndexedExpressionNode apply() {
            return this.oldNode.modify(this.containerExpression, this.openBracket, this.keyExpression, this.closeBracket);
        }
    }
}

