/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MappingBindingPatternNode
extends BindingPatternNode {
    public MappingBindingPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<BindingPatternNode> fieldBindingPatterns() {
        return new SeparatedNodeList<BindingPatternNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBrace", "fieldBindingPatterns", "closeBrace"};
    }

    public MappingBindingPatternNode modify(Token openBrace, SeparatedNodeList<BindingPatternNode> fieldBindingPatterns, Token closeBrace) {
        if (this.checkForReferenceEquality(openBrace, fieldBindingPatterns.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createMappingBindingPatternNode(openBrace, fieldBindingPatterns, closeBrace);
    }

    public MappingBindingPatternNodeModifier modify() {
        return new MappingBindingPatternNodeModifier(this);
    }

    public static class MappingBindingPatternNodeModifier {
        private final MappingBindingPatternNode oldNode;
        private Token openBrace;
        private SeparatedNodeList<BindingPatternNode> fieldBindingPatterns;
        private Token closeBrace;

        public MappingBindingPatternNodeModifier(MappingBindingPatternNode oldNode) {
            this.oldNode = oldNode;
            this.openBrace = oldNode.openBrace();
            this.fieldBindingPatterns = oldNode.fieldBindingPatterns();
            this.closeBrace = oldNode.closeBrace();
        }

        public MappingBindingPatternNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public MappingBindingPatternNodeModifier withFieldBindingPatterns(SeparatedNodeList<BindingPatternNode> fieldBindingPatterns) {
            Objects.requireNonNull(fieldBindingPatterns, "fieldBindingPatterns must not be null");
            this.fieldBindingPatterns = fieldBindingPatterns;
            return this;
        }

        public MappingBindingPatternNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public MappingBindingPatternNode apply() {
            return this.oldNode.modify(this.openBrace, this.fieldBindingPatterns, this.closeBrace);
        }
    }
}

