/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MethodCallExpressionNode
extends ExpressionNode {
    public MethodCallExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token dotToken() {
        return (Token)this.childInBucket(1);
    }

    public NameReferenceNode methodName() {
        return (NameReferenceNode)this.childInBucket(2);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(3);
    }

    public SeparatedNodeList<FunctionArgumentNode> arguments() {
        return new SeparatedNodeList<FunctionArgumentNode>((NonTerminalNode)this.childInBucket(4));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "dotToken", "methodName", "openParenToken", "arguments", "closeParenToken"};
    }

    public MethodCallExpressionNode modify(ExpressionNode expression, Token dotToken, NameReferenceNode methodName, Token openParenToken, SeparatedNodeList<FunctionArgumentNode> arguments, Token closeParenToken) {
        if (this.checkForReferenceEquality(expression, dotToken, methodName, openParenToken, arguments.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createMethodCallExpressionNode(expression, dotToken, methodName, openParenToken, arguments, closeParenToken);
    }

    public MethodCallExpressionNodeModifier modify() {
        return new MethodCallExpressionNodeModifier(this);
    }

    public static class MethodCallExpressionNodeModifier {
        private final MethodCallExpressionNode oldNode;
        private ExpressionNode expression;
        private Token dotToken;
        private NameReferenceNode methodName;
        private Token openParenToken;
        private SeparatedNodeList<FunctionArgumentNode> arguments;
        private Token closeParenToken;

        public MethodCallExpressionNodeModifier(MethodCallExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.dotToken = oldNode.dotToken();
            this.methodName = oldNode.methodName();
            this.openParenToken = oldNode.openParenToken();
            this.arguments = oldNode.arguments();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public MethodCallExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public MethodCallExpressionNodeModifier withDotToken(Token dotToken) {
            Objects.requireNonNull(dotToken, "dotToken must not be null");
            this.dotToken = dotToken;
            return this;
        }

        public MethodCallExpressionNodeModifier withMethodName(NameReferenceNode methodName) {
            Objects.requireNonNull(methodName, "methodName must not be null");
            this.methodName = methodName;
            return this;
        }

        public MethodCallExpressionNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public MethodCallExpressionNodeModifier withArguments(SeparatedNodeList<FunctionArgumentNode> arguments) {
            Objects.requireNonNull(arguments, "arguments must not be null");
            this.arguments = arguments;
            return this;
        }

        public MethodCallExpressionNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public MethodCallExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.dotToken, this.methodName, this.openParenToken, this.arguments, this.closeParenToken);
        }
    }
}

