/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.diagnostics.SyntaxDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class Node {
    protected final STNode internalNode;
    protected final int position;
    protected final NonTerminalNode parent;
    protected SyntaxTree syntaxTree;
    private LineRange lineRange;
    private TextRange textRange;
    private TextRange textRangeWithMinutiae;

    public Node(STNode internalNode, int position, NonTerminalNode parent) {
        this.internalNode = internalNode;
        this.position = position;
        this.parent = parent;
    }

    public int position() {
        return this.position;
    }

    public NonTerminalNode parent() {
        return this.parent;
    }

    public Optional<NonTerminalNode> ancestor(Predicate<Node> filter) {
        for (NonTerminalNode parent = this.parent; parent != null; parent = parent.parent()) {
            if (!filter.test(parent)) continue;
            return Optional.of(parent);
        }
        return Optional.empty();
    }

    public List<NonTerminalNode> ancestors() {
        ArrayList<NonTerminalNode> ancestors = new ArrayList<NonTerminalNode>();
        for (NonTerminalNode parent = this.parent; parent != null; parent = parent.parent()) {
            ancestors.add(parent);
        }
        return ancestors;
    }

    public TextRange textRange() {
        if (this.textRange != null) {
            return this.textRange;
        }
        int leadingMinutiaeDelta = this.internalNode.widthWithLeadingMinutiae() - this.internalNode.width();
        int positionWithoutLeadingMinutiae = this.position + leadingMinutiaeDelta;
        this.textRange = TextRange.from(positionWithoutLeadingMinutiae, this.internalNode.width());
        return this.textRange;
    }

    public TextRange textRangeWithMinutiae() {
        if (this.textRangeWithMinutiae != null) {
            return this.textRangeWithMinutiae;
        }
        this.textRangeWithMinutiae = TextRange.from(this.position, this.internalNode.widthWithMinutiae());
        return this.textRangeWithMinutiae;
    }

    public SyntaxKind kind() {
        return this.internalNode.kind;
    }

    public NodeLocation location() {
        return new NodeLocation(this);
    }

    public abstract Iterable<Diagnostic> diagnostics();

    public boolean hasDiagnostics() {
        return this.internalNode.hasDiagnostics();
    }

    public boolean isMissing() {
        return this.internalNode.isMissing();
    }

    public SyntaxTree syntaxTree() {
        return this.populateSyntaxTree();
    }

    public LineRange lineRange() {
        if (this.lineRange != null) {
            return this.lineRange;
        }
        SyntaxTree syntaxTree = this.syntaxTree();
        TextDocument textDocument = syntaxTree.textDocument();
        this.lineRange = LineRange.from(syntaxTree.filePath(), textDocument.linePositionFrom(this.textRange().startOffset()), textDocument.linePositionFrom(this.textRange().endOffset()));
        return this.lineRange;
    }

    public abstract MinutiaeList leadingMinutiae();

    public abstract MinutiaeList trailingMinutiae();

    public List<Token> leadingInvalidTokens() {
        return this.getInvalidTokens(this.leadingMinutiae());
    }

    public List<Token> trailingInvalidTokens() {
        return this.getInvalidTokens(this.trailingMinutiae());
    }

    List<Token> getInvalidTokens(MinutiaeList minutiaeList) {
        ArrayList<Token> invalidTokens = new ArrayList<Token>();
        for (Minutiae minutiae : minutiaeList) {
            minutiae.invalidTokenMinutiaeNode().ifPresent(invalidTokenMinutiaeNode -> {
                Token token = invalidTokenMinutiaeNode.invalidToken();
                invalidTokens.add(token);
            });
        }
        return invalidTokens;
    }

    public abstract void accept(NodeVisitor var1);

    public abstract <T> T apply(NodeTransformer<T> var1);

    public STNode internalNode() {
        return this.internalNode;
    }

    public String toString() {
        return this.internalNode.toString();
    }

    public String toSourceCode() {
        return this.internalNode.toSourceCode();
    }

    private SyntaxTree populateSyntaxTree() {
        if (this.syntaxTree != null) {
            return this.syntaxTree;
        }
        NonTerminalNode parent = this.parent;
        if (parent == null) {
            this.setSyntaxTree(SyntaxTree.from(this, false));
        } else {
            this.setSyntaxTree(parent.populateSyntaxTree());
        }
        return this.syntaxTree;
    }

    void setSyntaxTree(SyntaxTree syntaxTree) {
        this.syntaxTree = syntaxTree;
    }

    protected Diagnostic createSyntaxDiagnostic(STNodeDiagnostic nodeDiagnostic) {
        return SyntaxDiagnostic.from(nodeDiagnostic, this.location());
    }
}

