/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ParenthesizedArgList
extends NonTerminalNode {
    public ParenthesizedArgList(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<FunctionArgumentNode> arguments() {
        return new SeparatedNodeList<FunctionArgumentNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenToken", "arguments", "closeParenToken"};
    }

    public ParenthesizedArgList modify(Token openParenToken, SeparatedNodeList<FunctionArgumentNode> arguments, Token closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, arguments.underlyingListNode(), closeParenToken)) {
            return this;
        }
        return NodeFactory.createParenthesizedArgList(openParenToken, arguments, closeParenToken);
    }

    public ParenthesizedArgListModifier modify() {
        return new ParenthesizedArgListModifier(this);
    }

    public static class ParenthesizedArgListModifier {
        private final ParenthesizedArgList oldNode;
        private Token openParenToken;
        private SeparatedNodeList<FunctionArgumentNode> arguments;
        private Token closeParenToken;

        public ParenthesizedArgListModifier(ParenthesizedArgList oldNode) {
            this.oldNode = oldNode;
            this.openParenToken = oldNode.openParenToken();
            this.arguments = oldNode.arguments();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public ParenthesizedArgListModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public ParenthesizedArgListModifier withArguments(SeparatedNodeList<FunctionArgumentNode> arguments) {
            Objects.requireNonNull(arguments, "arguments must not be null");
            this.arguments = arguments;
            return this;
        }

        public ParenthesizedArgListModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public ParenthesizedArgList apply() {
            return this.oldNode.modify(this.openParenToken, this.arguments, this.closeParenToken);
        }
    }
}

