/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QueryPipelineNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class QueryActionNode
extends ActionNode {
    public QueryActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public QueryPipelineNode queryPipeline() {
        return (QueryPipelineNode)this.childInBucket(0);
    }

    public Token doKeyword() {
        return (Token)this.childInBucket(1);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"queryPipeline", "doKeyword", "blockStatement"};
    }

    public QueryActionNode modify(QueryPipelineNode queryPipeline, Token doKeyword, BlockStatementNode blockStatement) {
        if (this.checkForReferenceEquality(queryPipeline, doKeyword, blockStatement)) {
            return this;
        }
        return NodeFactory.createQueryActionNode(queryPipeline, doKeyword, blockStatement);
    }

    public QueryActionNodeModifier modify() {
        return new QueryActionNodeModifier(this);
    }

    public static class QueryActionNodeModifier {
        private final QueryActionNode oldNode;
        private QueryPipelineNode queryPipeline;
        private Token doKeyword;
        private BlockStatementNode blockStatement;

        public QueryActionNodeModifier(QueryActionNode oldNode) {
            this.oldNode = oldNode;
            this.queryPipeline = oldNode.queryPipeline();
            this.doKeyword = oldNode.doKeyword();
            this.blockStatement = oldNode.blockStatement();
        }

        public QueryActionNodeModifier withQueryPipeline(QueryPipelineNode queryPipeline) {
            Objects.requireNonNull(queryPipeline, "queryPipeline must not be null");
            this.queryPipeline = queryPipeline;
            return this;
        }

        public QueryActionNodeModifier withDoKeyword(Token doKeyword) {
            Objects.requireNonNull(doKeyword, "doKeyword must not be null");
            this.doKeyword = doKeyword;
            return this;
        }

        public QueryActionNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public QueryActionNode apply() {
            return this.oldNode.modify(this.queryPipeline, this.doKeyword, this.blockStatement);
        }
    }
}

