/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ReCharacterClassNode
extends NonTerminalNode {
    public ReCharacterClassNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public Optional<Token> negation() {
        return this.optionalChildInBucket(1);
    }

    public Optional<Node> reCharSet() {
        return this.optionalChildInBucket(2);
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "negation", "reCharSet", "closeBracket"};
    }

    public ReCharacterClassNode modify(Token openBracket, Token negation, Node reCharSet, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, negation, reCharSet, closeBracket)) {
            return this;
        }
        return NodeFactory.createReCharacterClassNode(openBracket, negation, reCharSet, closeBracket);
    }

    public ReCharacterClassNodeModifier modify() {
        return new ReCharacterClassNodeModifier(this);
    }

    public static class ReCharacterClassNodeModifier {
        private final ReCharacterClassNode oldNode;
        private Token openBracket;
        private Token negation;
        private Node reCharSet;
        private Token closeBracket;

        public ReCharacterClassNodeModifier(ReCharacterClassNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.negation = oldNode.negation().orElse(null);
            this.reCharSet = oldNode.reCharSet().orElse(null);
            this.closeBracket = oldNode.closeBracket();
        }

        public ReCharacterClassNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ReCharacterClassNodeModifier withNegation(Token negation) {
            this.negation = negation;
            return this;
        }

        public ReCharacterClassNodeModifier withReCharSet(Node reCharSet) {
            this.reCharSet = reCharSet;
            return this;
        }

        public ReCharacterClassNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ReCharacterClassNode apply() {
            return this.oldNode.modify(this.openBracket, this.negation, this.reCharSet, this.closeBracket);
        }
    }
}

