/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.BallerinaLexer;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.text.CharReader;
import java.util.Arrays;
import java.util.List;

public final class SyntaxInfo {
    private static final List<String> BALLERINA_KEYWORDS = Arrays.stream(SyntaxKind.values()).filter(syntaxKind -> SyntaxKind.RE_KEYWORD.compareTo(syntaxKind) > 0).map(SyntaxKind::stringValue).toList();

    private SyntaxInfo() {
    }

    public static List<String> keywords() {
        return BALLERINA_KEYWORDS;
    }

    public static boolean isKeyword(String text) {
        return BALLERINA_KEYWORDS.contains(text);
    }

    public static boolean isIdentifier(String text) {
        BallerinaLexer ballerinaLexer = new BallerinaLexer(CharReader.from(text));
        Token token = (Token)ballerinaLexer.nextToken().createUnlinkedFacade();
        return token.kind() == SyntaxKind.IDENTIFIER_TOKEN && !token.hasDiagnostics() && text.equals(token.text());
    }
}

