/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLAttributeValue;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import java.util.Objects;

public class XMLAttributeNode
extends NonTerminalNode {
    public XMLAttributeNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public XMLNameNode attributeName() {
        return (XMLNameNode)this.childInBucket(0);
    }

    public Token equalToken() {
        return (Token)this.childInBucket(1);
    }

    public XMLAttributeValue value() {
        return (XMLAttributeValue)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"attributeName", "equalToken", "value"};
    }

    public XMLAttributeNode modify(XMLNameNode attributeName, Token equalToken, XMLAttributeValue value) {
        if (this.checkForReferenceEquality(attributeName, equalToken, value)) {
            return this;
        }
        return NodeFactory.createXMLAttributeNode(attributeName, equalToken, value);
    }

    public XMLAttributeNodeModifier modify() {
        return new XMLAttributeNodeModifier(this);
    }

    public static class XMLAttributeNodeModifier {
        private final XMLAttributeNode oldNode;
        private XMLNameNode attributeName;
        private Token equalToken;
        private XMLAttributeValue value;

        public XMLAttributeNodeModifier(XMLAttributeNode oldNode) {
            this.oldNode = oldNode;
            this.attributeName = oldNode.attributeName();
            this.equalToken = oldNode.equalToken();
            this.value = oldNode.value();
        }

        public XMLAttributeNodeModifier withAttributeName(XMLNameNode attributeName) {
            Objects.requireNonNull(attributeName, "attributeName must not be null");
            this.attributeName = attributeName;
            return this;
        }

        public XMLAttributeNodeModifier withEqualToken(Token equalToken) {
            Objects.requireNonNull(equalToken, "equalToken must not be null");
            this.equalToken = equalToken;
            return this;
        }

        public XMLAttributeNodeModifier withValue(XMLAttributeValue value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
            return this;
        }

        public XMLAttributeNode apply() {
            return this.oldNode.modify(this.attributeName, this.equalToken, this.value);
        }
    }
}

