/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import java.util.Objects;

public class XMLProcessingInstruction
extends XMLItemNode {
    public XMLProcessingInstruction(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token piStart() {
        return (Token)this.childInBucket(0);
    }

    public XMLNameNode target() {
        return (XMLNameNode)this.childInBucket(1);
    }

    public NodeList<Node> data() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(2));
    }

    public Token piEnd() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"piStart", "target", "data", "piEnd"};
    }

    public XMLProcessingInstruction modify(Token piStart, XMLNameNode target, NodeList<Node> data, Token piEnd) {
        if (this.checkForReferenceEquality(piStart, target, data.underlyingListNode(), piEnd)) {
            return this;
        }
        return NodeFactory.createXMLProcessingInstruction(piStart, target, data, piEnd);
    }

    public XMLProcessingInstructionModifier modify() {
        return new XMLProcessingInstructionModifier(this);
    }

    public static class XMLProcessingInstructionModifier {
        private final XMLProcessingInstruction oldNode;
        private Token piStart;
        private XMLNameNode target;
        private NodeList<Node> data;
        private Token piEnd;

        public XMLProcessingInstructionModifier(XMLProcessingInstruction oldNode) {
            this.oldNode = oldNode;
            this.piStart = oldNode.piStart();
            this.target = oldNode.target();
            this.data = oldNode.data();
            this.piEnd = oldNode.piEnd();
        }

        public XMLProcessingInstructionModifier withPiStart(Token piStart) {
            Objects.requireNonNull(piStart, "piStart must not be null");
            this.piStart = piStart;
            return this;
        }

        public XMLProcessingInstructionModifier withTarget(XMLNameNode target) {
            Objects.requireNonNull(target, "target must not be null");
            this.target = target;
            return this;
        }

        public XMLProcessingInstructionModifier withData(NodeList<Node> data) {
            Objects.requireNonNull(data, "data must not be null");
            this.data = data;
            return this;
        }

        public XMLProcessingInstructionModifier withPiEnd(Token piEnd) {
            Objects.requireNonNull(piEnd, "piEnd must not be null");
            this.piEnd = piEnd;
            return this;
        }

        public XMLProcessingInstruction apply() {
            return this.oldNode.modify(this.piStart, this.target, this.data, this.piEnd);
        }
    }
}

