/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class XMLStepIndexedExtendNode
extends NonTerminalNode {
    public XMLStepIndexedExtendNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "expression", "closeBracket"};
    }

    public XMLStepIndexedExtendNode modify(Token openBracket, ExpressionNode expression, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, expression, closeBracket)) {
            return this;
        }
        return NodeFactory.createXMLStepIndexedExtendNode(openBracket, expression, closeBracket);
    }

    public XMLStepIndexedExtendNodeModifier modify() {
        return new XMLStepIndexedExtendNodeModifier(this);
    }

    public static class XMLStepIndexedExtendNodeModifier {
        private final XMLStepIndexedExtendNode oldNode;
        private Token openBracket;
        private ExpressionNode expression;
        private Token closeBracket;

        public XMLStepIndexedExtendNodeModifier(XMLStepIndexedExtendNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.expression = oldNode.expression();
            this.closeBracket = oldNode.closeBracket();
        }

        public XMLStepIndexedExtendNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public XMLStepIndexedExtendNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public XMLStepIndexedExtendNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public XMLStepIndexedExtendNode apply() {
            return this.oldNode.modify(this.openBracket, this.expression, this.closeBracket);
        }
    }
}

