/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SeparatedNodeList;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;

public class KeyNode
extends NonTerminalNode {
    public KeyNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public SeparatedNodeList<ValueNode> value() {
        return new SeparatedNodeList<ValueNode>((NonTerminalNode)this.childInBucket(0));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"value"};
    }

    public KeyNode modify(SeparatedNodeList<ValueNode> value) {
        if (this.checkForReferenceEquality(value.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createKeyNode(value);
    }

    public KeyNodeModifier modify() {
        return new KeyNodeModifier(this);
    }

    public static class KeyNodeModifier {
        private final KeyNode oldNode;
        private SeparatedNodeList<ValueNode> value;

        public KeyNodeModifier(KeyNode oldNode) {
            this.oldNode = oldNode;
            this.value = oldNode.value();
        }

        public KeyNodeModifier withValue(SeparatedNodeList<ValueNode> value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
            return this;
        }

        public KeyNode apply() {
            return this.oldNode.modify(this.value);
        }
    }
}

