/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;
import java.util.Optional;

public class LiteralStringLiteralNode
extends ValueNode {
    public LiteralStringLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token startSingleQuote() {
        return (Token)this.childInBucket(0);
    }

    public Optional<Token> content() {
        return this.optionalChildInBucket(1);
    }

    public Token endSingleQuote() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startSingleQuote", "content", "endSingleQuote"};
    }

    public LiteralStringLiteralNode modify(Token startSingleQuote, Token content, Token endSingleQuote) {
        if (this.checkForReferenceEquality(startSingleQuote, content, endSingleQuote)) {
            return this;
        }
        return NodeFactory.createLiteralStringLiteralNode(startSingleQuote, content, endSingleQuote);
    }

    public LiteralStringLiteralNodeModifier modify() {
        return new LiteralStringLiteralNodeModifier(this);
    }

    public static class LiteralStringLiteralNodeModifier {
        private final LiteralStringLiteralNode oldNode;
        private Token startSingleQuote;
        private Token content;
        private Token endSingleQuote;

        public LiteralStringLiteralNodeModifier(LiteralStringLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.startSingleQuote = oldNode.startSingleQuote();
            this.content = oldNode.content().orElse(null);
            this.endSingleQuote = oldNode.endSingleQuote();
        }

        public LiteralStringLiteralNodeModifier withStartSingleQuote(Token startSingleQuote) {
            Objects.requireNonNull(startSingleQuote, "startSingleQuote must not be null");
            this.startSingleQuote = startSingleQuote;
            return this;
        }

        public LiteralStringLiteralNodeModifier withContent(Token content) {
            this.content = content;
            return this;
        }

        public LiteralStringLiteralNodeModifier withEndSingleQuote(Token endSingleQuote) {
            Objects.requireNonNull(endSingleQuote, "endSingleQuote must not be null");
            this.endSingleQuote = endSingleQuote;
            return this;
        }

        public LiteralStringLiteralNode apply() {
            return this.oldNode.modify(this.startSingleQuote, this.content, this.endSingleQuote);
        }
    }
}

