/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.syntax.tree;

import io.ballerina.toml.internal.parser.tree.STNode;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeTransformer;
import io.ballerina.toml.syntax.tree.NodeVisitor;
import io.ballerina.toml.syntax.tree.NonTerminalNode;
import io.ballerina.toml.syntax.tree.SyntaxKind;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.syntax.tree.ValueNode;
import java.util.Objects;
import java.util.Optional;

public class NumericLiteralNode
extends ValueNode {
    public NumericLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> sign() {
        return this.optionalChildInBucket(0);
    }

    public Token value() {
        return (Token)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"sign", "value"};
    }

    public NumericLiteralNode modify(SyntaxKind kind, Token sign, Token value) {
        if (this.checkForReferenceEquality(sign, value)) {
            return this;
        }
        return NodeFactory.createNumericLiteralNode(kind, sign, value);
    }

    public NumericLiteralNodeModifier modify() {
        return new NumericLiteralNodeModifier(this);
    }

    public static class NumericLiteralNodeModifier {
        private final NumericLiteralNode oldNode;
        private Token sign;
        private Token value;

        public NumericLiteralNodeModifier(NumericLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.sign = oldNode.sign().orElse(null);
            this.value = oldNode.value();
        }

        public NumericLiteralNodeModifier withSign(Token sign) {
            this.sign = sign;
            return this;
        }

        public NumericLiteralNodeModifier withValue(Token value) {
            Objects.requireNonNull(value, "value must not be null");
            this.value = value;
            return this;
        }

        public NumericLiteralNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.sign, this.value);
        }
    }
}

