/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.toml.validator.schema;

import io.ballerina.toml.semantic.ast.TomlNode;
import io.ballerina.toml.validator.schema.CompositionSchema;
import io.ballerina.toml.validator.schema.SchemaVisitor;
import io.ballerina.toml.validator.schema.Type;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class AbstractSchema {
    private final String description;
    private final Type type;
    private final Map<String, String> message;
    private final CompositionSchema compositionSchemas;

    public AbstractSchema(Type type, Map<String, String> message, CompositionSchema compositionSchemas, String desc) {
        this.type = type;
        this.message = message;
        this.compositionSchemas = compositionSchemas;
        this.description = desc;
    }

    public Type type() {
        return this.type;
    }

    public Map<String, String> message() {
        return this.message;
    }

    public Optional<CompositionSchema> compositionSchemas() {
        return Optional.ofNullable(this.compositionSchemas);
    }

    public abstract void accept(SchemaVisitor var1);

    public <T extends TomlNode> List<Diagnostic> validate(T givenValueNode, String key) {
        if (this.compositionSchemas().isPresent()) {
            CompositionSchema compositionSchema = this.compositionSchemas().get();
            return compositionSchema.validate(givenValueNode, key);
        }
        return Collections.emptyList();
    }

    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }
}

