/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websubhub.task;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websubhub.WebSubHubDiagnosticCodes;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public final class AnalyserUtils {
    private AnalyserUtils() {
    }

    public static void updateContext(SyntaxNodeAnalysisContext context, WebSubHubDiagnosticCodes errorCode, NodeLocation location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.getCode(), errorCode.getDescription(), errorCode.getSeverity());
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
        context.reportDiagnostic(diagnostic);
    }

    public static boolean isWebSubHubListener(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(AnalyserUtils::isWebSubHubListenerType);
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return AnalyserUtils.isWebSubHubListenerType((TypeReferenceTypeSymbol)listenerType);
        }
        if (listenerType.typeKind() == TypeDescKind.OBJECT) {
            Optional moduleOpt = listenerType.getModule();
            return moduleOpt.isPresent() && AnalyserUtils.isWebSubHub((ModuleSymbol)moduleOpt.get());
        }
        return false;
    }

    private static boolean isWebSubHubListenerType(TypeReferenceTypeSymbol typeSymbol) {
        if (typeSymbol.getName().isEmpty() || !"Listener".equals(typeSymbol.getName().get())) {
            return false;
        }
        return typeSymbol.getModule().isPresent() && AnalyserUtils.isWebSubHub((ModuleSymbol)typeSymbol.getModule().get());
    }

    public static boolean isWebSubHub(ModuleSymbol moduleSymbol) {
        Optional moduleNameOpt = moduleSymbol.getName();
        return moduleNameOpt.isPresent() && "websubhub".equals(moduleNameOpt.get()) && "ballerina".equals(moduleSymbol.id().orgName());
    }

    public static String getTypeDescription(TypeSymbol paramType) {
        TypeDescKind paramKind = paramType.typeKind();
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)paramKind)) {
            TypeSymbol internalType = ((TypeReferenceTypeSymbol)paramType).typeDescriptor();
            if (internalType instanceof ErrorTypeSymbol) {
                return AnalyserUtils.getErrorTypeDescription(paramType);
            }
            String moduleName = paramType.getModule().flatMap(Symbol::getName).orElse("");
            String type = paramType.getName().orElse("");
            return AnalyserUtils.getQualifiedType(type, moduleName);
        }
        if (TypeDescKind.UNION.equals((Object)paramKind)) {
            List availableTypes = ((UnionTypeSymbol)paramType).memberTypeDescriptors();
            boolean optionalSymbolAvailable = availableTypes.stream().anyMatch(t -> TypeDescKind.NIL.equals((Object)t.typeKind()));
            String concatenatedTypeDesc = availableTypes.stream().map(AnalyserUtils::getTypeDescription).filter(e -> !e.isEmpty() && !e.isBlank()).reduce((a, b) -> String.join((CharSequence)"|", a, b)).orElse("");
            return optionalSymbolAvailable ? concatenatedTypeDesc + "?" : concatenatedTypeDesc;
        }
        if (TypeDescKind.INTERSECTION.equals((Object)paramKind)) {
            List availableTypes = ((IntersectionTypeSymbol)paramType).memberTypeDescriptors();
            boolean containsHttpHeaders = availableTypes.stream().anyMatch(e -> "http:Headers".equals(AnalyserUtils.getTypeDescription(e)));
            return availableTypes.stream().filter(e -> containsHttpHeaders || !TypeDescKind.READONLY.equals((Object)e.typeKind())).map(AnalyserUtils::getTypeDescription).filter(e -> !e.isEmpty() && !e.isBlank()).reduce((a, b) -> String.join((CharSequence)" & ", a, b)).orElse("");
        }
        if (TypeDescKind.ERROR.equals((Object)paramKind)) {
            return AnalyserUtils.getErrorTypeDescription(paramType);
        }
        if (TypeDescKind.READONLY.equals((Object)paramKind)) {
            return "readonly";
        }
        return paramType.getName().orElse("");
    }

    private static String getErrorTypeDescription(TypeSymbol internalType) {
        String signature = internalType.signature();
        Optional<ModuleID> moduleIdOpt = internalType.getModule().map(ModuleSymbol::id);
        String moduleId = moduleIdOpt.map(ModuleID::toString).orElse("");
        String type = signature.replace(moduleId, "").replace(":", "");
        String moduleName = moduleIdOpt.map(ModuleID::modulePrefix).orElse("");
        return AnalyserUtils.getQualifiedType(type, moduleName);
    }

    public static String getQualifiedType(String paramType, String moduleName) {
        return moduleName.isBlank() ? paramType : String.format("%s:%s", moduleName, paramType);
    }

    public static boolean isRemoteMethod(FunctionSymbol functionSymbol) {
        return functionSymbol.qualifiers().contains(Qualifier.REMOTE);
    }
}

