/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websubhub.task;

import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websubhub.task.AnalyserUtils;
import io.ballerina.stdlib.websubhub.task.validator.ServiceDeclarationValidator;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Optional;

public class ServiceAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final ServiceDeclarationValidator validator = ServiceDeclarationValidator.getInstance();

    public void perform(SyntaxNodeAnalysisContext context) {
        ServiceDeclarationSymbol serviceDeclarationSymbol;
        boolean erroneousCompilation = context.semanticModel().diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)context.node();
        Optional serviceDeclarationOpt = context.semanticModel().symbol((Node)serviceNode);
        if (serviceDeclarationOpt.isPresent() && this.isWebSubHubService(serviceDeclarationSymbol = (ServiceDeclarationSymbol)serviceDeclarationOpt.get())) {
            this.validator.validate(context, serviceNode);
        }
    }

    private boolean isWebSubHubService(ServiceDeclarationSymbol serviceDeclarationSymbol) {
        return serviceDeclarationSymbol.listenerTypes().stream().anyMatch(AnalyserUtils::isWebSubHubListener);
    }
}

