/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.exception;

import io.ballerina.graphql.generator.client.diagnostic.ClientDiagnosticMessages;
import io.ballerina.graphql.generator.utils.NullLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.LineRange;
import io.ballerina.tools.text.TextRange;

public class ClientCodeGenerationException
extends Exception {
    private String errMessage;
    private String projectName;

    public ClientCodeGenerationException(String errMessage, Throwable e) {
        super(errMessage, e);
        this.errMessage = errMessage;
    }

    public ClientCodeGenerationException(String errMessage) {
        super(errMessage);
        this.errMessage = errMessage;
    }

    public ClientCodeGenerationException(String errMessage, String projectName) {
        super(errMessage);
        this.errMessage = errMessage;
        this.projectName = projectName;
    }

    private static String generateDescription(ClientDiagnosticMessages message, String ... args) {
        return String.format(message.getDescription(), args);
    }

    public Diagnostic createDiagnostic(ClientDiagnosticMessages diagnosticMessage, Location location, String ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticMessage.getCode(), ClientCodeGenerationException.generateDescription(diagnosticMessage, args), diagnosticMessage.getSeverity());
        if (location == null) {
            location = NullLocation.getInstance();
        }
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]);
        return diagnostic;
    }

    public Location getLocation() {
        return new Location(){

            public LineRange lineRange() {
                LinePosition from = LinePosition.from((int)0, (int)0);
                return LineRange.from((String)("(" + ClientCodeGenerationException.this.projectName + ":)"), (LinePosition)from, (LinePosition)from);
            }

            public TextRange textRange() {
                return TextRange.from((int)0, (int)0);
            }
        };
    }

    @Override
    public String getMessage() {
        if (this.projectName != null) {
            Diagnostic diagnostic = this.createDiagnostic(ClientDiagnosticMessages.GRAPHQL_CLIENT_GEN_104, this.getLocation(), this.errMessage + "\nPlease check project : " + this.projectName);
            return diagnostic.toString();
        }
        return this.errMessage;
    }

    public String getErrMessage() {
        return this.errMessage;
    }
}

