/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator;

import graphql.schema.GraphQLSchema;
import io.ballerina.graphql.generator.CodeGenerator;
import io.ballerina.graphql.generator.GraphqlProject;
import io.ballerina.graphql.generator.client.GraphqlClientProject;
import io.ballerina.graphql.generator.client.exception.ClientCodeGenerationException;
import io.ballerina.graphql.generator.client.exception.ClientGenerationException;
import io.ballerina.graphql.generator.client.exception.ClientTypesGenerationException;
import io.ballerina.graphql.generator.client.exception.ConfigTypesGenerationException;
import io.ballerina.graphql.generator.client.exception.UtilsGenerationException;
import io.ballerina.graphql.generator.client.generator.ballerina.AuthConfigGenerator;
import io.ballerina.graphql.generator.client.generator.ballerina.ClientGenerator;
import io.ballerina.graphql.generator.client.generator.ballerina.ClientTypesGenerator;
import io.ballerina.graphql.generator.client.generator.ballerina.ConfigTypesGenerator;
import io.ballerina.graphql.generator.client.generator.ballerina.UtilsGenerator;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.client.pojo.Extension;
import io.ballerina.graphql.generator.utils.GeneratorContext;
import io.ballerina.graphql.generator.utils.SrcFilePojo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ClientCodeGenerator
extends CodeGenerator {
    @Override
    public void generate(GraphqlProject project) throws ClientCodeGenerationException {
        String outputPath = project.getOutputPath();
        try {
            List<SrcFilePojo> genSources = this.generateBalSources(project, GeneratorContext.CLI);
            this.writeGeneratedSources(genSources, Path.of(outputPath, new String[0]));
        }
        catch (IOException e) {
            throw new ClientCodeGenerationException(e.getMessage(), project.getName());
        }
        catch (NullPointerException e) {
            throw new ClientCodeGenerationException("The provided schema includes operations that are not supported by the client generation.", project.getName());
        }
    }

    public List<SrcFilePojo> generateBalSources(GraphqlProject project, GeneratorContext generatorContext) throws ClientGenerationException, UtilsGenerationException, ClientTypesGenerationException, ConfigTypesGenerationException {
        String projectName = project.getName();
        Extension extensions = ((GraphqlClientProject)project).getExtensions();
        List<String> documents = ((GraphqlClientProject)project).getDocuments();
        GraphQLSchema schema = project.getGraphQLSchema();
        AuthConfig authConfig = new AuthConfig();
        AuthConfigGenerator.getInstance().populateAuthConfigTypes(extensions, authConfig);
        AuthConfigGenerator.getInstance().populateApiHeaders(extensions, authConfig);
        ArrayList<SrcFilePojo> sourceFiles = new ArrayList<SrcFilePojo>();
        this.generateClients(projectName, documents, schema, authConfig, sourceFiles, generatorContext);
        this.generateUtils(projectName, authConfig, sourceFiles);
        this.generateClientTypes(projectName, documents, schema, sourceFiles);
        this.generateConfigTypes(projectName, authConfig, sourceFiles);
        return sourceFiles;
    }

    private void generateClients(String projectName, List<String> documents, GraphQLSchema schema, AuthConfig authConfig, List<SrcFilePojo> sourceFiles, GeneratorContext generatorContext) throws ClientGenerationException {
        String clientSrc = ClientGenerator.getInstance().generateSrc(documents, schema, authConfig, generatorContext);
        sourceFiles.add(new SrcFilePojo(SrcFilePojo.GenFileType.GEN_SRC, projectName, "client.bal", clientSrc));
    }

    private void generateClientTypes(String projectName, List<String> documents, GraphQLSchema schema, List<SrcFilePojo> sourceFiles) throws ClientTypesGenerationException {
        String typesFileContent = "";
        typesFileContent = ClientTypesGenerator.getInstance().generateSrc(schema, documents);
        sourceFiles.add(new SrcFilePojo(SrcFilePojo.GenFileType.MODEL_SRC, projectName, "types.bal", typesFileContent));
    }

    public void generateUtils(String projectName, AuthConfig authConfig, List<SrcFilePojo> sourceFiles) throws UtilsGenerationException {
        String utilSrc = UtilsGenerator.getInstance().generateSrc(authConfig);
        sourceFiles.add(new SrcFilePojo(SrcFilePojo.GenFileType.UTIL_SRC, projectName, "utils.bal", utilSrc));
    }

    private void generateConfigTypes(String projectName, AuthConfig authConfig, List<SrcFilePojo> sourceFiles) throws ConfigTypesGenerationException {
        String configTypesSrc = ConfigTypesGenerator.getInstance().generateSrc(authConfig);
        sourceFiles.add(new SrcFilePojo(SrcFilePojo.GenFileType.CONFIG_SRC, projectName, "config_types.bal", configTypesSrc));
    }
}

