/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.graphql.generator.CodeGeneratorConstants;
import io.ballerina.graphql.generator.client.exception.ConfigTypesGenerationException;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigTypesGenerator {
    private static ConfigTypesGenerator configTypesGenerator = null;
    private static final String CONNECTION_CONFIG = "ConnectionConfig";
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigTypesGenerator.class);

    public static ConfigTypesGenerator getInstance() {
        if (configTypesGenerator == null) {
            configTypesGenerator = new ConfigTypesGenerator();
        }
        return configTypesGenerator;
    }

    public String generateSrc(AuthConfig authConfig) throws ConfigTypesGenerationException {
        try {
            return Formatter.format((SyntaxTree)this.generateSyntaxTree(authConfig)).toString();
        }
        catch (IOException | FormatterException e) {
            throw new ConfigTypesGenerationException(e.getMessage());
        }
    }

    private SyntaxTree generateSyntaxTree(AuthConfig authConfig) throws IOException {
        ArrayList<Object> memberDeclarationNodes = new ArrayList<Object>();
        Path path = this.getResourceFilePath();
        Project project = ProjectLoader.loadProject((Path)path);
        Package currentPackage = project.currentPackage();
        DocumentId docId = (DocumentId)currentPackage.getDefaultModule().documentIds().iterator().next();
        SyntaxTree syntaxTree = currentPackage.getDefaultModule().document(docId).syntaxTree();
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        NodeList imports = modulePartNode.imports();
        NodeList members = modulePartNode.members();
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        for (ModuleMemberDeclarationNode node : members) {
            if (authConfig.isClientConfig()) {
                if (node.kind().equals((Object)SyntaxKind.TYPE_DEFINITION) && ((TypeDefinitionNode)node).typeName().text().equals(CONNECTION_CONFIG)) {
                    node = this.constructConnectionConfig(node, authConfig);
                }
                memberDeclarationNodes.add(node);
                continue;
            }
            memberDeclarationNodes.add(node);
        }
        if (authConfig.isApiKeysConfig()) {
            IdentifierToken typeName = AbstractNodeFactory.createIdentifierToken((String)"ApiKeysConfig");
            NodeList nodeList = AbstractNodeFactory.createNodeList(this.generateApiKeysConfigRecordFields(authConfig));
            RecordTypeDescriptorNode recordTypeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)nodeList, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
            TypeDefinitionNode typeDefinitionNode = NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)typeName, (Node)recordTypeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            memberDeclarationNodes.add(typeDefinitionNode);
        }
        ModulePartNode moduleNode = NodeFactory.createModulePartNode((NodeList)imports, (NodeList)AbstractNodeFactory.createNodeList(memberDeclarationNodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree configTypeSyntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return configTypeSyntaxTree.modifyWith((Node)moduleNode);
    }

    private TypeDefinitionNode constructConnectionConfig(ModuleMemberDeclarationNode node, AuthConfig authConfig) {
        RecordTypeDescriptorNode connectionConfigNode = (RecordTypeDescriptorNode)((TypeDefinitionNode)node).typeDescriptor();
        MetadataNode authMetadataNode = CodeGeneratorUtils.getMetadataNode("Configurations related to client authentication");
        String authName = authConfig.getAuthConfigTypes().contains((Object)CodeGeneratorConstants.AuthConfigType.BEARER) ? CodeGeneratorConstants.AuthConfigType.BEARER.getValue() : CodeGeneratorConstants.AuthConfigType.BASIC.getValue();
        IdentifierToken authFieldName = AbstractNodeFactory.createIdentifierToken((String)authName);
        RecordFieldNode authConfigNode = NodeFactory.createRecordFieldNode((MetadataNode)authMetadataNode, null, (Node)authFieldName, (Token)AbstractNodeFactory.createIdentifierToken((String)"auth"), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        ArrayList<Object> tokens = new ArrayList<Object>();
        NodeList fields = connectionConfigNode.fields();
        tokens.add(authConfigNode);
        for (Node n : fields) {
            tokens.add(n);
        }
        NodeList nodeList = AbstractNodeFactory.createNodeList(tokens);
        RecordTypeDescriptorNode.RecordTypeDescriptorNodeModifier recordTypeDescriptorNodeModifier = connectionConfigNode.modify().withFields(nodeList);
        connectionConfigNode = recordTypeDescriptorNodeModifier.apply();
        return NodeFactory.createTypeDefinitionNode((MetadataNode)((MetadataNode)((TypeDefinitionNode)node).metadata().get()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)((TypeDefinitionNode)node).typeName(), (Node)connectionConfigNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private Path getResourceFilePath() throws IOException {
        Path path = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("templates/config_types_graphql.bal");
        if (inputStream != null) {
            String clientSyntaxTreeString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Path tmpDir = Files.createTempDirectory(".config_types_graphql-tmp" + System.nanoTime(), new FileAttribute[0]);
            path = tmpDir.resolve("config_types_graphql.bal");
            try (PrintWriter writer = new PrintWriter(path.toString(), StandardCharsets.UTF_8);){
                writer.print(clientSyntaxTreeString);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.deleteDirectory((File)tmpDir.toFile());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to delete the temporary directory : " + String.valueOf(tmpDir), (Throwable)ex);
                }
            }));
        }
        return path;
    }

    private List<Node> generateApiKeysConfigRecordFields(AuthConfig authConfig) {
        ArrayList<Node> ballerinaApiKeysConfigRecords = new ArrayList<Node>();
        for (String headerName : authConfig.getApiHeaders()) {
            MetadataNode metadataNode = NodeFactory.createMetadataNode(null, this.generateSensitiveFieldsAnnotation());
            SimpleNameReferenceNode typeName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
            IdentifierToken apiKeyFieldName = AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.getValidName(headerName));
            ballerinaApiKeysConfigRecords.add((Node)NodeFactory.createRecordFieldNode((MetadataNode)metadataNode, null, (Node)typeName, (Token)apiKeyFieldName, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
        }
        return ballerinaApiKeysConfigRecords;
    }

    private NodeList<AnnotationNode> generateSensitiveFieldsAnnotation() {
        ArrayList<Object> annotFields = new ArrayList<Object>();
        LinkedHashMap<String, String> extFields = new LinkedHashMap<String, String>();
        extFields.put("label", "");
        extFields.put("kind", "password");
        for (Map.Entry field : extFields.entrySet()) {
            BasicLiteralNode valueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)NodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.STRING_LITERAL_TOKEN, (String)("\"" + ((String)field.getValue()).trim() + "\""), (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createEmptyMinutiaeList()));
            SpecificFieldNode fields = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)((String)field.getKey()).trim()), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)valueExpr);
            annotFields.add(fields);
            annotFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        MappingConstructorExpressionNode annotValue = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(annotFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        SimpleNameReferenceNode annotateReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"display"));
        AnnotationNode annotationNode = NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotateReference, (MappingConstructorExpressionNode)annotValue);
        return AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{annotationNode});
    }
}

