/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import graphql.language.Field;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.schema.GraphQLSchema;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.graphql.generator.client.Utils;
import io.ballerina.graphql.generator.client.generator.graphql.QueryReader;
import io.ballerina.graphql.generator.client.generator.graphql.SpecReader;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedFieldDefinition;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedFragmentDefinition;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedOperationDefinition;
import io.ballerina.graphql.generator.client.generator.graphql.components.SelectionData;
import io.ballerina.graphql.generator.client.generator.model.FieldType;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TypesGenerator {
    private static final Log log = LogFactory.getLog(TypesGenerator.class);
    private static TypesGenerator typesGenerator = null;

    public static TypesGenerator getInstance() {
        if (typesGenerator == null) {
            typesGenerator = new TypesGenerator();
        }
        return typesGenerator;
    }

    protected void addQueryResponseRecords(GraphQLSchema schema, List<String> documents, List<TypeDefinitionNode> typeDefinitionNodeList) throws IOException {
        String queryObjectTypeName = "Query";
        String mutationObjectTypeName = "Mutation";
        if (schema.getQueryType() != null) {
            queryObjectTypeName = schema.getQueryType().getName();
        }
        if (schema.getMutationType() != null) {
            mutationObjectTypeName = schema.getMutationType().getName();
        }
        Map<String, FieldType> queryFieldsMap = SpecReader.getObjectTypeFieldsMap(schema, queryObjectTypeName);
        Map<String, FieldType> mutationFieldsMap = SpecReader.getObjectTypeFieldsMap(schema, mutationObjectTypeName);
        queryFieldsMap.putAll(mutationFieldsMap);
        RecordFieldNode extensionsFieldNode = this.getExtensionsRecField();
        HashMap<String, String> fragmentRecordsMap = new HashMap<String, String>();
        for (String document : documents) {
            QueryReader queryReader = new QueryReader(Utils.getGraphQLQueryDocument(document));
            for (ExtendedOperationDefinition definition : queryReader.getExtendedOperationDefinitions()) {
                String queryName = definition.getName();
                ArrayList<RecordFieldNode> queryRecordFieldList = new ArrayList<RecordFieldNode>();
                queryRecordFieldList.add(extensionsFieldNode);
                for (ExtendedFieldDefinition extendedFieldDefinition : definition.getExtendedFieldDefinitions()) {
                    String fieldName = extendedFieldDefinition.getName();
                    String selectionType = queryFieldsMap.get(fieldName).getName();
                    String recordFieldName = fieldName;
                    if (extendedFieldDefinition.getAlias() != null) {
                        recordFieldName = extendedFieldDefinition.getAlias();
                    }
                    Map<String, FieldType> fieldsOfSelectionType = SpecReader.getObjectTypeFieldsMap(schema, selectionType);
                    ArrayList<Node> fieldsOfInlineRecord = new ArrayList<Node>();
                    SelectionData selectionData = new SelectionData(selectionType, fieldsOfSelectionType, schema, queryReader, fieldsOfInlineRecord, typeDefinitionNodeList, fragmentRecordsMap);
                    for (Selection selection : extendedFieldDefinition.getSelectionSet().getSelections()) {
                        this.handleSelection(selection, selectionData);
                    }
                    NodeList recFieldNodesOfInlineRecord = AbstractNodeFactory.createNodeList(fieldsOfInlineRecord);
                    RecordTypeDescriptorNode inlineRecord = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)recFieldNodesOfInlineRecord, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
                    RecordFieldNode queryRecordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)NodeFactory.createIdentifierToken((String)(String.valueOf(inlineRecord) + queryFieldsMap.get(fieldName).getTokens())), (Token)NodeFactory.createIdentifierToken((String)CodeGeneratorUtils.escapeIdentifier(recordFieldName)), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                    queryRecordFieldList.add(queryRecordFieldNode);
                }
                NodeList queryResponseRecFields = AbstractNodeFactory.createNodeList(queryRecordFieldList);
                RecordTypeDescriptorNode queryResponseRecord = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)queryResponseRecFields, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
                MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
                TypeDefinitionNode typeDefNode = NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)NodeFactory.createIdentifierToken((String)this.getQueryResponseTypeName(queryName)), (Node)queryResponseRecord, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                typeDefinitionNodeList.add(typeDefNode);
            }
        }
    }

    private void handleSelection(Selection selection, SelectionData selectionData) {
        if (selection instanceof FragmentSpread) {
            this.handleFragmentSpread(selection, selectionData);
        } else if (selection instanceof InlineFragment) {
            this.handleInlineFragment((InlineFragment)selection, selectionData);
        } else {
            this.handleField(selection, selectionData);
        }
    }

    private void handleFragmentSpread(Selection selection, SelectionData selectionData) {
        String fragmentName = ((FragmentSpread)selection).getName();
        String fragmentTypeName = this.getFragmentTypeName(fragmentName);
        selectionData.getFieldsOfInlineRecord().add((Node)NodeFactory.createIncludedRecordParameterNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ASTERISK_TOKEN), (Node)NodeFactory.createIdentifierToken((String)fragmentTypeName), (Token)NodeFactory.createIdentifierToken((String)(String.valueOf(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)) + "\n"))));
        if (!selectionData.getFragmentRecordsMap().containsKey(fragmentName)) {
            this.addFragmentRecord((FragmentSpread)selection, selectionData);
            selectionData.getFragmentRecordsMap().put(fragmentName, fragmentTypeName);
        }
    }

    private void handleField(Selection selection, SelectionData selectionData) {
        Field field = (Field)selection;
        if (field.getSelectionSet() != null) {
            this.createInlineRecordField(field, selectionData);
        } else {
            String fieldName = field.getName();
            String typeOfField = selectionData.getFieldsOfSelectionType().get(fieldName).getFieldTypeAsString();
            selectionData.getFieldsOfInlineRecord().add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)NodeFactory.createIdentifierToken((String)(typeOfField + " ")), (Token)NodeFactory.createIdentifierToken((String)fieldName), null, (Token)NodeFactory.createIdentifierToken((String)(String.valueOf(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)) + "\n"))));
        }
    }

    private void addFragmentRecord(FragmentSpread fragmentSpread, SelectionData selectionData) {
        ArrayList<Node> recordFieldList = new ArrayList<Node>();
        String fragmentName = fragmentSpread.getName();
        for (ExtendedFragmentDefinition fragmentDef : selectionData.getQueryReader().getExtendedFragmentDefinitions()) {
            if (!fragmentName.equals(fragmentDef.getName())) continue;
            SelectionData fragmentSelData = new SelectionData(selectionData.getSelectionType(), selectionData.getFieldsOfSelectionType(), selectionData.getSchema(), selectionData.getQueryReader(), recordFieldList, selectionData.getTypeDefinitionNodeList(), selectionData.getFragmentRecordsMap());
            for (Selection selection : fragmentDef.getSelectionSet().getSelections()) {
                if (selection instanceof Field) {
                    Field field = (Field)selection;
                    if (field.getSelectionSet() != null) {
                        this.createInlineRecordField(field, fragmentSelData);
                        continue;
                    }
                    String fieldName = field.getName();
                    String typeOfField = fragmentSelData.getFieldsOfSelectionType().get(fieldName).getFieldTypeAsString();
                    recordFieldList.add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)NodeFactory.createIdentifierToken((String)(typeOfField + " ")), (Token)NodeFactory.createIdentifierToken((String)fieldName), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
                    continue;
                }
                this.handleSelection(selection, fragmentSelData);
            }
        }
        NodeList fragmentTypeFields = AbstractNodeFactory.createNodeList(recordFieldList);
        RecordTypeDescriptorNode fragmentRecord = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)fragmentTypeFields, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        TypeDefinitionNode typeDefNode = NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)NodeFactory.createIdentifierToken((String)this.getFragmentTypeName(fragmentName)), (Node)fragmentRecord, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        selectionData.getTypeDefinitionNodeList().add(typeDefNode);
    }

    private void handleInlineFragment(InlineFragment inlineFragment, SelectionData selectionData) {
        for (Selection selection : inlineFragment.getSelectionSet().getSelections()) {
            this.handleSelection(selection, selectionData);
        }
    }

    private void createInlineRecordField(Field inlineRecordField, SelectionData selectionData) {
        String inlineRecordFieldName = inlineRecordField.getName();
        Map<String, FieldType> objectFieldsMap = SpecReader.getObjectTypeFieldsMap(selectionData.getSchema(), selectionData.getSelectionType());
        String selectionType = objectFieldsMap.get(inlineRecordFieldName).getName();
        Map<String, FieldType> fieldsOfSelectionType = SpecReader.getObjectTypeFieldsMap(selectionData.getSchema(), selectionType);
        SelectionSet selectionSet = inlineRecordField.getSelectionSet();
        ArrayList<Node> fieldList = new ArrayList<Node>();
        SelectionData inlineRecFieldData = new SelectionData(selectionType, fieldsOfSelectionType, selectionData.getSchema(), selectionData.getQueryReader(), fieldList, selectionData.getTypeDefinitionNodeList(), selectionData.getFragmentRecordsMap());
        for (Selection selection : selectionSet.getSelections()) {
            this.handleSelection(selection, inlineRecFieldData);
        }
        NodeList fields = AbstractNodeFactory.createNodeList(fieldList);
        RecordTypeDescriptorNode typeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_PIPE_TOKEN), (NodeList)fields, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_PIPE_TOKEN));
        selectionData.getFieldsOfInlineRecord().add((Node)NodeFactory.createRecordFieldNode(null, null, (Node)NodeFactory.createIdentifierToken((String)(String.valueOf(typeDescriptorNode) + objectFieldsMap.get(inlineRecordFieldName).getTokens())), (Token)NodeFactory.createIdentifierToken((String)inlineRecordFieldName), null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
    }

    protected void addInputRecords(GraphQLSchema schema, List<TypeDefinitionNode> typeDefinitionNodeList) {
        List<String> inputObjectTypes = SpecReader.getInputObjectTypeNames(schema);
        for (String inputObjectType : inputObjectTypes) {
            ArrayList<RecordFieldNode> recordFieldList = new ArrayList<RecordFieldNode>();
            Map<String, FieldType> inputTypeFieldsMap = SpecReader.getInputTypeFieldsMap(schema, inputObjectType);
            for (Map.Entry<String, FieldType> inputTypeFields : inputTypeFieldsMap.entrySet()) {
                String typeName = inputTypeFields.getValue().getFieldTypeAsString();
                String fieldName = inputTypeFields.getKey();
                RecordFieldNode recordFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)NodeFactory.createIdentifierToken((String)typeName), (Token)NodeFactory.createIdentifierToken((String)fieldName), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
                recordFieldList.add(recordFieldNode);
            }
            NodeList fieldNodes = AbstractNodeFactory.createNodeList(recordFieldList);
            RecordTypeDescriptorNode typeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)fieldNodes, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
            MetadataNode metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
            TypeDefinitionNode typeDefNode = NodeFactory.createTypeDefinitionNode((MetadataNode)metadataNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.PUBLIC_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)NodeFactory.createIdentifierToken((String)inputObjectType), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            typeDefinitionNodeList.add(typeDefNode);
        }
    }

    private String getQueryResponseTypeName(String queryName) {
        return queryName.substring(0, 1).toUpperCase() + queryName.substring(1).concat("Response");
    }

    private String getFragmentTypeName(String fragmentName) {
        return fragmentName.substring(0, 1).toUpperCase() + fragmentName.substring(1).concat("Fragment");
    }

    private RecordFieldNode getExtensionsRecField() {
        RecordFieldNode extensionsFieldNode = NodeFactory.createRecordFieldNode(null, null, (Node)NodeFactory.createIdentifierToken((String)"map<json?>"), (Token)NodeFactory.createIdentifierToken((String)"__extensions"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        return extensionsFieldNode;
    }
}

