/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SingletonTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.graphql.generator.client.exception.UtilsGenerationException;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class UtilsGenerator {
    private static final Log log = LogFactory.getLog(UtilsGenerator.class);
    private static UtilsGenerator utilsGenerator = null;

    public static UtilsGenerator getInstance() {
        if (utilsGenerator == null) {
            utilsGenerator = new UtilsGenerator();
        }
        return utilsGenerator;
    }

    public String generateSrc(AuthConfig authConfig) throws UtilsGenerationException {
        try {
            return Formatter.format((SyntaxTree)this.generateSyntaxTree(authConfig)).toString();
        }
        catch (IOException | FormatterException e) {
            throw new UtilsGenerationException(e.getMessage());
        }
    }

    public SyntaxTree generateSyntaxTree(AuthConfig authConfig) throws IOException {
        NodeList<ImportDeclarationNode> importsList = this.generateImports();
        ArrayList<Object> members = new ArrayList<Object>();
        if (authConfig.isApiKeysConfig()) {
            members.add(this.getSimpleBasicTypeDefinitionNode());
        }
        members.add(this.getOperationResponseTypeDefinitionNode());
        members.add(this.getDataResponseTypeDefinitionNode());
        Path path = this.getResourceFilePath();
        Project project = ProjectLoader.loadProject((Path)path);
        Package currentPackage = project.currentPackage();
        DocumentId docId = (DocumentId)currentPackage.getDefaultModule().documentIds().iterator().next();
        SyntaxTree utilSyntaxTree = currentPackage.getDefaultModule().document(docId).syntaxTree();
        ModulePartNode utilModulePartNode = (ModulePartNode)utilSyntaxTree.rootNode();
        NodeList memberDeclarationNodes = utilModulePartNode.members();
        for (ModuleMemberDeclarationNode node : memberDeclarationNodes) {
            if (!node.kind().equals((Object)SyntaxKind.FUNCTION_DEFINITION)) continue;
            for (ChildNodeEntry childNodeEntry : node.childEntries()) {
                if (!childNodeEntry.name().equals("functionName")) continue;
                if (authConfig.isApiKeysConfig() && ((Node)childNodeEntry.node().get()).toString().equals("getMapForHeaders")) {
                    members.add(node);
                }
                if (!((Node)childNodeEntry.node().get()).toString().equals("performDataBinding")) continue;
                members.add(node);
            }
        }
        ModulePartNode modulePartNode = NodeFactory.createModulePartNode(importsList, (NodeList)AbstractNodeFactory.createNodeList(members), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private NodeList<ImportDeclarationNode> generateImports() {
        ArrayList<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
        ImportDeclarationNode importForGraphql = CodeGeneratorUtils.getImportDeclarationNode("ballerina", "graphql");
        imports.add(importForGraphql);
        return AbstractNodeFactory.createNodeList(imports);
    }

    private TypeDefinitionNode getSimpleBasicTypeDefinitionNode() {
        SingletonTypeDescriptorNode typeDescriptorNode = NodeFactory.createSingletonTypeDescriptorNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string|boolean|int|float|decimal")));
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"SimpleBasicType"), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDefinitionNode getOperationResponseTypeDefinitionNode() {
        SingletonTypeDescriptorNode typeDescriptorNode = NodeFactory.createSingletonTypeDescriptorNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"record {| anydata...; |}|record {| anydata...; |}[]|boolean|string|int|float|()")));
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"OperationResponse"), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private TypeDefinitionNode getDataResponseTypeDefinitionNode() {
        SingletonTypeDescriptorNode typeDescriptorNode = NodeFactory.createSingletonTypeDescriptorNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"record {|\n   map<json?> __extensions?;\n   OperationResponse ...;\n|}")));
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"DataResponse"), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private Path getResourceFilePath() throws IOException {
        Path path = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("templates/utils_graphql.bal");
        if (inputStream != null) {
            String clientSyntaxTreeString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Path tmpDir = Files.createTempDirectory(".util-tmp" + System.nanoTime(), new FileAttribute[0]);
            path = tmpDir.resolve("utils.bal");
            try (PrintWriter writer = new PrintWriter(path.toString(), StandardCharsets.UTF_8);){
                writer.print(clientSyntaxTreeString);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.deleteDirectory((File)tmpDir.toFile());
                }
                catch (IOException ex) {
                    log.error((Object)("Unable to delete the temporary directory : " + String.valueOf(tmpDir)), (Throwable)ex);
                }
            }));
        }
        return path;
    }
}

