/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.graphql;

import graphql.language.ListType;
import graphql.language.NonNullType;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.schema.GraphQLSchema;
import io.ballerina.graphql.generator.client.generator.graphql.SpecReader;
import io.ballerina.graphql.generator.client.generator.model.FieldType;

public class Utils {
    public static String getBallerinaTypeName(GraphQLSchema graphQLSchema, String graphqlTypeName) {
        String ballerinaTypeName;
        if (Utils.isCustomScalarType(graphQLSchema, graphqlTypeName).booleanValue()) {
            ballerinaTypeName = "anydata";
        } else if (Utils.isEnumType(graphQLSchema, graphqlTypeName).booleanValue()) {
            ballerinaTypeName = "string";
        } else {
            switch (graphqlTypeName) {
                case "ID": 
                case "String": {
                    ballerinaTypeName = "string";
                    break;
                }
                case "Int": {
                    ballerinaTypeName = "int";
                    break;
                }
                case "Float": {
                    ballerinaTypeName = "float";
                    break;
                }
                case "Boolean": {
                    ballerinaTypeName = "boolean";
                    break;
                }
                default: {
                    ballerinaTypeName = graphqlTypeName;
                }
            }
        }
        return ballerinaTypeName;
    }

    public static FieldType getFieldType(GraphQLSchema graphQLSchema, Type<?> type) {
        FieldType fieldType = new FieldType();
        if (type instanceof TypeName) {
            fieldType.setName(Utils.getBallerinaTypeName(graphQLSchema, ((TypeName)type).getName()));
            fieldType.setTokens("?");
        }
        if (type instanceof NonNullType) {
            if (((NonNullType)type).getType() instanceof TypeName) {
                fieldType.setName(Utils.getBallerinaTypeName(graphQLSchema, ((TypeName)((NonNullType)type).getType()).getName()));
                fieldType.setTokens("");
            }
            if (((NonNullType)type).getType() instanceof ListType) {
                if (((ListType)((NonNullType)type).getType()).getType() instanceof TypeName) {
                    fieldType.setName(Utils.getBallerinaTypeName(graphQLSchema, ((TypeName)((ListType)((NonNullType)type).getType()).getType()).getName()));
                    fieldType.setTokens("?[]");
                }
                if (((ListType)((NonNullType)type).getType()).getType() instanceof NonNullType && ((NonNullType)((ListType)((NonNullType)type).getType()).getType()).getType() instanceof TypeName) {
                    fieldType.setName(Utils.getBallerinaTypeName(graphQLSchema, ((TypeName)((NonNullType)((ListType)((NonNullType)type).getType()).getType()).getType()).getName()));
                    fieldType.setTokens("[]");
                }
            }
        }
        if (type instanceof ListType) {
            if (((ListType)type).getType() instanceof TypeName) {
                fieldType.setName(Utils.getBallerinaTypeName(graphQLSchema, ((TypeName)((ListType)type).getType()).getName()));
                fieldType.setTokens("?[]?");
            }
            if (((ListType)type).getType() instanceof NonNullType && ((NonNullType)((ListType)type).getType()).getType() instanceof TypeName) {
                fieldType.setName(Utils.getBallerinaTypeName(graphQLSchema, ((TypeName)((NonNullType)((ListType)type).getType()).getType()).getName()));
                fieldType.setTokens("[]?");
            }
        }
        return fieldType;
    }

    public static Boolean isPrimitiveScalarType(String graphqlTypeName) {
        return switch (graphqlTypeName) {
            case "ID", "String", "Int", "Float", "Boolean" -> true;
            default -> false;
        };
    }

    public static Boolean isCustomScalarType(GraphQLSchema graphQLSchema, String graphqlTypeName) {
        return SpecReader.getCustomScalarTypeNames(graphQLSchema).contains(graphqlTypeName);
    }

    public static Boolean isEnumType(GraphQLSchema graphQLSchema, String graphqlTypeName) {
        return SpecReader.getEnumTypeNames(graphQLSchema).contains(graphqlTypeName);
    }
}

